VERSION=1.7

LDFLAGS=-L/usr/X11R6/lib -L$(QTDIR)/lib
LDLIBS=$(LIBRARY) -lqt -lX11
#CXXFLAGS=-Wall -g -I$(QTDIR)/include -I.
CXXFLAGS=-Wall -O2 -I$(QTDIR)/include -I.
MOCS=moc_QwSpriteField.cpp
SRC=QwSpriteField.cpp QwSpriteField-double.cpp QwSpriteField-int.cpp \
	QwSpriteField-mobdouble.cpp QwSpriteField-mobint.cpp QwCluster.cpp \
	$(MOCS)
OBJ=QwSpriteField.o QwSpriteField-double.o QwSpriteField-int.o \
	QwSpriteField-mobdouble.o QwSpriteField-mobint.o QwCluster.o \
	moc_QwSpriteField.o
LIBRARY=libQwSpriteField.a

all: $(LIBRARY) example

$(LIBRARY): $(OBJ)
	ar rs $(LIBRARY) $?

example: example.o moc_example.o $(LIBRARY)

distrib_src:
	@echo
	@cvs update
	@echo
	@cd ..; tar --create --compress --file QwSpriteField/QwSpriteField$(VERSION)-srconly.tar.gz \
		--exclude '*/example' \
		--exclude '*/sprite/*' \
		--exclude '*/html/*' \
		--exclude '*/html/article.html' \
		--exclude '*/ANNOUNCE*' \
		--exclude '*/CHANGES*' \
		--exclude '*/d*.conf' \
		--exclude '*.gz' \
		--exclude '*/pngtoppmpgm' \
		--exclude '*CVS*' \
		--exclude '*.o' \
		--exclude '*/?' \
		--exclude '*/core' \
		--exclude '*.out' \
		--exclude '*.a' \
		--exclude '*~' \
		--exclude '*.bak' \
		--exclude '*.moc' \
		--exclude '*/moc_*' \
		--exclude '*/.*' \
		--exclude '*/contrib*' \
		--exclude 'QwSpriteField/QwSpriteField[1-9]*' \
		--exclude 'QwSpriteField/QwSpriteField-[1-9]*' \
		--exclude 'Dependencies' \
		QwSpriteField

distrib: $(LIBRARY) example
	@echo
	@cvs update
	@echo
	@echo "REMEMBER to also:"
	@echo "   cvs tag release_$(subst .,_,$(VERSION))"
	@echo "   scp QwSpriteField$(VERSION).tar.gz ftp.troll.no:/local/ftp/contrib"
	@echo "   scp html/* trolls.troll.no:public_html/QwSpriteField"
	@echo "   cd ~/kde/kdesupport"
	@echo "      diff -ur --exclude=CVS --exclude=.cvsignore --exclude=moc* \\"
	@echo "           --exclude=Makefile \\"
	@echo "           QwSpriteField ~/usr/QwSpriteField >d"
	@echo "      grep '^diff' d | sed -e 's/.* //'"
	@echo "      patch -s <d"
	@echo
	@strip example
	@cd ..; tar --create --compress --file QwSpriteField/QwSpriteField$(VERSION).tar.gz \
		--exclude '*/example' \
		--exclude '*/html/article.html' \
		--exclude '*/ANNOUNCE*' \
		--exclude '*/CHANGES*' \
		--exclude '*/d*.conf' \
		--exclude '*.gz' \
		--exclude '*/pngtoppmpgm' \
		--exclude '*CVS*' \
		--exclude '*.o' \
		--exclude '*/?' \
		--exclude '*/core' \
		--exclude '*.out' \
		--exclude '*.a' \
		--exclude '*~' \
		--exclude '*.bak' \
		--exclude '*.moc' \
		--exclude '*/moc_*' \
		--exclude '*/.*' \
		--exclude '*/contrib*' \
		--exclude 'QwSpriteField/QwSpriteField[1-9]*' \
		--exclude 'QwSpriteField/QwSpriteField-[1-9]*' \
		--exclude 'Dependencies' \
		QwSpriteField

moc_%.cpp: %.h
	moc $*.h -o moc_$*.cpp

QwSpriteField-%.o: QwSpriteField-%.cpp
	$(COMPILE.cc) QwSpriteField-$*.cpp $(OUTPUT_OPTION)

%.o: %.cpp
	$(COMPILE.cc) $< $(OUTPUT_OPTION)

clean:
	-rm doc/html/*~ *~ *.o *.moc core

depend: $(MOCS) FORCE
	$(CXX) $(CXXFLAGS) -M $(SRC) >Dependencies

FORCE:

Dependencies:
	@echo "Making file $@ automatically."
	touch Dependencies
	make depend

include Dependencies


