#include <stdio.h>
#include <iostream>
#include <string.h>
#include <unistd.h>

#include <qpopupmenu.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qlistview.h>

#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kpmatrix.h>
#include <kmessagebox.h>
#include <kprogress.h>
#include <kapp.h>
#include <kpcomm.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kprocess.h>
#include <kmsgbox.h>
#include <kstdaccel.h>
#include <kiconloader.h>
#include <klocale.h>

#include "kplottool.h"
#include "ktlitem.h"

//Won't run KPlot (define this when debugging)
//#define DONTRUN




//Statusbar
const int S_MAIN=1;

const int MAXCONNECTTRIES=10;
const int CONNECTTIMEOUT=200;


const int ID_OPEN = 1;

KPlotTool::KPlotTool (const char *name) :
  KTMainWindow (name)
{
  KStdAccel keys;

  file = new QPopupMenu;
  idimportmatrix=file->insertItem ("&Import Matrix...", this, SLOT(slotImport()),
		    CTRL+Key_I);
  file->insertItem ("&Quit", kapp, SLOT(quit()), keys.quit());
  //  idaddmatrix=file->insertItem ("&Add Matrix...", this, SLOT(slotAdd()),  CTRL+Key_A);
  //  idreload=file->insertItem ("&Reload...", this, SLOT(slotReload()),CTRL+Key_R);        
  menuBar()->insertItem ("&File", file);

  menuBar()->insertSeparator();
  menuBar()->insertItem ("&Help", helpMenu (i18n("This is an example KPlot client") ));

  KStatusBar *ks = statusBar();
  //  ks->setInsertOrder (KStatusBar::RightToLeft);
  ks->insertItem (" ", S_MAIN);

  toolBar()->insertButton(BarIcon ("fileopen.xpm"),
			  ID_OPEN, SIGNAL (clicked()), this,
			  SLOT (slotImport()),
			  true, "Import Matrix..."); 

  dirpath = "";

  tree = new QListView (this);
  tree->addColumn ("Plot name");
  tree->setRootIsDecorated (true);
  page1 = new KTLItem (tree, "Page 1");

  connect ( tree, SIGNAL(currentChanged (QListViewItem *)),
	    SLOT (slotCurrentChanged (QListViewItem *)) );

  connect ( tree, SIGNAL(doubleClicked (QListViewItem *)),
	    SLOT (slotDoubleClicked (QListViewItem *)) );
  connect ( tree, SIGNAL(returnPressed (QListViewItem *)),
	    SLOT (slotReturnPressed (QListViewItem *)) );

  setView (tree);


  statusBar()->changeItem ("Starting KPlot", S_MAIN);
#ifndef DONTRUN
  startKPlot();
#endif

  connectmessage = "Establishing data connection";
  statusBar()->changeItem (connectmessage, S_MAIN);
  connecttries=0;
  QTimer::singleShot (CONNECTTIMEOUT, this, SLOT(slotMakeConnection()));


  resize (400,150);
  currentmatrixid=0;
}

void
KPlotTool::startKPlot (void)
{
  printf ("Starting kplot\n");
  kproc = new KProcess;

  socketname.sprintf ("/tmp/kpcomm.%d", getpid());

  *kproc << "kplotserver" << socketname;


  connect ( kproc, 
	    SIGNAL (receivedStdout(KProcess *, char *, int )),
	    this,
	    SLOT ( slotOutput(KProcess *, char *, int)) );
  connect ( kproc, 
	    SIGNAL (receivedStderr(KProcess *, char *, int )),
	    this,
	    SLOT ( slotOutput(KProcess *, char *, int)) );
  kproc->start  (KProcess::NotifyOnExit, KProcess::All);
}

void
KPlotTool::closeEvent (QCloseEvent *ce)
{
#ifndef DONTRUN
  if (kproc->isRunning())
      kproc->kill();
#endif
  KTMainWindow::closeEvent (ce);
}

void
KPlotTool::slotConnectionLost (KSocket *)
{
  close();
}

void
KPlotTool::slotMakeConnection()
{
  kpcomm = new KPComm(socketname);
  printf ("SOCK  %d\n",kpcomm->socket());
  if (kpcomm->socket()==-1)
    {
      connectmessage+=".";
      statusBar()->changeItem (connectmessage, S_MAIN);
      connecttries++;

      delete kpcomm;
      if (connecttries>MAXCONNECTTRIES)
	{
	  statusBar()->changeItem (i18n("Connect failed"), S_MAIN);
	  KMessageBox::
	    error ( 0, i18n("Could not establish a"
			    " connection to KPlot\n"
			    " Please be sure that kplot is in your PATH.\n\n"
			    " KPlotTool will quit now."),
		    i18n("Connection failed") );
	  
	  close();
	}
      else
	{
	  QTimer::singleShot (CONNECTTIMEOUT, this, SLOT(slotMakeConnection()));
	}
      return;
    }

  connect ( kpcomm, SIGNAL (messageWaiting (int)),
            this, SLOT (slotMessageWaiting (int)) );
  connect ( kpcomm, SIGNAL (closeEvent (KSocket *)),
            this, SLOT (slotConnectionLost (KSocket*)) );
  
}

void
KPlotTool::slotMessageWaiting (int message)
{
  char *data=0;
  int datasize, id, option;
  data = (char *)kpcomm->get (message, option, datasize, id);

  printf ("CLIENT:  message is [%d]\n", message);
  printf ("CLIENT:  option is [%d]\n", option);
  kpcomm->releaseData (data, id);
}

void
KPlotTool::slotImport ()
{
  printf ("IMPORT\n");
  QString data ("Hello");
  printf ("CLIENT SENDING [%s]\n", (const char *)data);
  kpcomm->send (KPComm::NOP, 0, (const char *)data, sizeof (char)*strlen(data));


  /*  QString filename = KFileDialog::getOpenFileName(dirpath,
						  QString::null,
						  0,
						  "Import matrix");
  */

  cout << "Enter filename:" << endl;
  char f [255];
  scanf ("%s",f);
  QString filename (f);

  printf ("filename=[%s]\n", (const char*)filename);
  if (filename.isNull())
    return;
  
  KURL url (filename);
  dirpath = url.directory();

  createFromFile (filename);
}

void
KPlotTool::createFromFile (QString filename, bool add)
{
  //Turn off the *flood* of signals from KSocket
  kpcomm->enableRead (false);
  kpcomm->enableWrite (false);

  KPMatrix *m=loadMatrix (filename);

  kpcomm->enableRead (true);
  kpcomm->enableWrite (true);

  if (!m)
    return;

  //Send matrix description to KPlot
  KURL url (filename);
  QString matrixname (url.filename());
  matrixname.truncate (254);

  kpcomm->sendMatrixDescription (currentmatrixid, m->nRows(), m->nCols(),
				 matrixname);
  
  //Send matrix data to KPlot
  kpcomm->sendMatrix (currentmatrixid, m->nRows(), m->nCols(), m->matrix());

  //  updateMenusEtc ();

  QString qs ("Imported ");
  qs += filename;
  statusBar()->changeItem ((const char *)qs, S_MAIN);

  if (add)
    {
      //Add everything to page 1 right now.
      
      KTLItem *item = new KTLItem (page1, matrixname, m->nRows(), m->nCols(),
				   filename);
      tree->ensureItemVisible (item);
    }
}

KPMatrix *
KPlotTool::loadMatrix (const QString &filename)
{


  QString qs;
  QFile file (filename);
  file.open (IO_ReadOnly);
  unsigned int size = file.size();

  int e,f,g;
  int savepos;

  qs.sprintf ("Loading %s", (const char *)filename);
  statusBar()->changeItem (qs, S_MAIN);

  if (size==0)
    {
      KMessageBox::
	sorry ( this, i18n("Cannot load matrix.  No data."),
		i18n("Matrix Read Error") );

      qs = "Load failed:  Empty file.";
      statusBar()->changeItem (qs, S_MAIN);
      return 0L;
    }


  //This is a huge sloppy hack.
  int nextupdate=0;
  QWidget *dialog = new QWidget (0);
  cancelwid=dialog;
  QGridLayout *layout = new QGridLayout (dialog, 2, 2, 10);
  QLabel *l = new QLabel ("Loading matrix: ", dialog);
  l->setAlignment (AlignRight);
  l->setMinimumSize (l->sizeHint());
  layout->addWidget (l, 0, 0);
  KProgress *prog = new KProgress (0, size, 0, KProgress::Horizontal, dialog);
  //  prog.setBarStyle (KProgress::Blocked);
  prog->setMinimumHeight (1.33*l->sizeHint().height());
  prog->setMinimumWidth (prog->sizeHint().width());
  layout->addWidget (prog, 0, 1);
  QPushButton *cancelbtn = new QPushButton ("&Cancel", dialog);
  cancelbtn->setDefault (false);
  cancelbtn->setMinimumSize (cancelbtn->sizeHint());
  connect ( cancelbtn, SIGNAL (clicked()),
	    this, SLOT (slotCancel()) );
  layout->addMultiCellWidget (cancelbtn, 1, 1, 0, 1);
  
  layout->freeze();

  
  bcanceled=false;
  dialog->setCaption ("Load matrix - KPlot");
  //  QTimer::singleShot (500, this, SLOT (slotShow()) );
  dialog->show();
  dialog->move (mapToGlobal (QPoint( (width() - dialog->width())/2,
				     (height() - dialog->height())/2) ));
  kapp->processEvents();

  //Skip initial comments
  do
    {
      savepos = file.at();
      e=file.readLine (qs, 512);

      if (e<0) //or e<1?
	{
	  delete dialog;
	  KMessageBox::
	    sorry ( this, i18n("Cannot load matrix.  No data."),
		    i18n("Matrix Read Error") );
	  qs = i18n("Load failed:  Invalid format.");
	  statusBar()->changeItem (qs, S_MAIN);

	  return 0L;
	}
    } while (qs[0]=='#' || qs[0]=='%' || qs[0]=='\n');



  int nc=0;
  //How many columns?

  //column separators are ' ', ',', ';', ':'
  //Turn them all into spaces.
  for (unsigned int i=0;i<qs.length();i++)
    if (qs[i]==',' || qs[i]==';' || qs[i]==':')
      qs[i]=' ';
  QString qs2=qs.simplifyWhiteSpace();
  qs=qs2;

  f=0;
  while ( (f=qs.find (' ', f))!=-1)
    {
      nc++;
      f++;
    }

  nc++;

  KPMatrix *m;
  /*  if (nc==1)
    m = new KPMatrix (2);
    else*/

  m = new KPMatrix (nc);

  file.at(savepos);

  int ir=0, ic=0;
  int ncm1=nc-1;
  int cnt=0;

  char *tmp;
  tmp = new char [512];
  while (file.readLine (tmp, 512)>0)
    {
      qs=tmp;
      
      //while (file.readLine (qs, 512)>0)
      //    {
      //      cout << (const char*)qs << endl;
      if (file.at()>nextupdate)
	{
	  prog->setValue (file.at());
	  kapp->processEvents();
	  if (bcanceled==true)
	    {
	      delete m;
	      delete dialog;
	      return 0L;
	    }
	  nextupdate += file.size()/20;
	}
      
      //column separators are ' ', ',', ';', ':'
      //Turn them all into spaces.
      for (unsigned int i=0;i<qs.length();i++)
	if (qs[i]==',' || qs[i]==';' || qs[i]==':')
	  qs[i]=' ';
      QString qs2=qs.simplifyWhiteSpace();
      qs=qs2;

      //      cout << qs << endl;
      g=f=0;
      ic=0;

      
      //Skip comment lines  (later: process commands)
      if (qs[0]=='#' || qs[0]=='%' || qs[0]=='\n')
	continue;
      while (ic<nc)
	{
	  double d;
	  
	  f=qs.find (' ', f);
	  if (f==-1 && ic!=ncm1)
	    {
	      delete dialog;
	      KMessageBox::
		sorry ( this, i18n("Cannot load matrix.  It is not in\n"
				   " MxN (rectangular) format."),
		        i18n("Matrix Format Error") );
	      
	      delete m;
	      return 0L;
	    }
	  
	  if (f==-1)
	    f=qs.length();
	  d=atof (qs.mid (g,f-g));
	  if (nc==1)
	    {
	      m->set (ir, 0, cnt);
	      m->set (ir, 1, d);
	    }
	  else
	    m->set (ir, ic, d);
	  
	  cnt++;
	  ic++;
	  f++;
	  g=f;
	}
      ir++;
    }
  delete tmp;
  
  
  qs.sprintf ("Loaded %s", (const char*)filename);
  statusBar()->changeItem (qs, S_MAIN);
  
  delete dialog;
  return m;
}

void
KPlotTool::slotCancel ()
{
  bcanceled=true;
  cancelwid->hide();
}

void
KPlotTool::slotShow ()
{
  cancelwid->show();
}

void
KPlotTool::slotOutput (KProcess *proc, char *buffer, int buflen)
{
  char *bufnew = new char [buflen+1];
  qstrncpy (bufnew, buffer, buflen);
  bufnew[buflen]='\0';
  printf ("KPLOT: [%s]\n", bufnew);

  delete bufnew;
}

void
KPlotTool::slotCurrentChanged (QListViewItem *qitem)
{
  KTLItem *item = (KTLItem *)qitem;
  statusBar()->message (item->filename());
}

void
KPlotTool::slotDoubleClicked (QListViewItem *qitem)
{
  KTLItem *item = (KTLItem *)qitem;
  if (!item->filename().isNull())
    createFromFile (item->filename(), false);
}

void
KPlotTool::slotReturnPressed (QListViewItem *qitem)
{
  slotDoubleClicked (qitem);
}

