#ifndef __KPLOTTOOL_H__
#define __KPLOTTOOL_H__


#include <qstring.h>
#include <qstrlist.h>

#include <ktmainwindow.h>

#include <kpmessages.h>

class QWidget;
class QListView;
class QListViewItem;
class KTLItem;

class KPComm;
class KPMatrix;
class KProcess;
class KSocket;


class KPlotTool : public KTMainWindow
{
 Q_OBJECT

 public:
  KPlotTool (const char *name=0);
  
 public slots:
   void slotImport ();
   void slotMessageWaiting (int message);
   void slotShow();
   void slotCancel();
   void slotMakeConnection();
   void slotConnectionLost( KSocket *);
   void slotOutput (KProcess *, char *, int);

   void slotCurrentChanged (QListViewItem *);
   void slotDoubleClicked (QListViewItem *);
   void slotReturnPressed (QListViewItem *);

 protected:
   virtual KPMatrix *loadMatrix (const QString &filename);
   virtual void closeEvent (QCloseEvent *);
   void startKPlot (void);



   /**
    * Find the record with the given <em>index</em>
    *  in matrices.
    **/
   int findIndex (int index);

   void createFromFile (QString filename, bool add=true);
 private:
   QPopupMenu *file;
   int idimportmatrix;
   int currentmatrixid;

   QString connectmessage;
   int connecttries;

   QString socketname;

   KPComm *kpcomm;
   QString dirpath;
   QStrList filenames;
   QWidget *cancelwid;
   bool bcanceled;
   QListView *tree;
   KProcess *kproc;

   KTLItem *page1;
};

#endif
