#ifndef __KTLITEM_H__
#define __KTLITEM_H__

#include <qlistview.h>

class KTLItem : public QListViewItem
{
 public:
  KTLItem (QListView *parent, const char *text,
	   int _nrows=0, int _ncols=0,
	   const QString filename=QString::null);
  KTLItem (QListViewItem *parent, const char *text,
	   int _nrows=0, int _ncols=0,
	   const QString filename=QString::null);

  int nCols () const {return ncols;}
  int nRows () const {return nrows;}

  QString filename () { return qsfilename; }

 protected:
  int nrows, ncols;
  QString qsfilename;

 private:
  void init ( const char *text,
	      int _nrows, int _ncols,
	      const QString filename);
};


#endif
