/**
 * KPS2D
 * David Sweet
 *
 * A superclass for 2D plots.
 **/


#ifndef __KPS2D_H__
#define __KPS2D_H__

#include <qobject.h>

#include "kpsprite.h"
#include "kpcoords.h"
#include "kpswhatami.h"


class KPView;
class KPSAxis;
class KPSCoordFrame;
class KPMatrix;

class KPS2D : public KPSprite
{
 Q_OBJECT

 friend KPView;

 public:
  KPS2D (KPView *view, const KPCoords &coords, KPMatrix *matrix, 
		double x, double y, double w, double h, int z=0);

  KPS2D (KPView *view, const KPCoords &coords,
		double x, double y, double w, double h, int z=0);


  /**
   * Find a good set of coordinates for this plot.
   **/
  virtual KPCoords autoCoords (const KPCoords *c = 0);

  /**
   * Set the matrix to plot. (not implemented)
   */
  void setMatrix (KPMatrix *_matrix);
  
  /**
   * Returns the matrix being used for plotting.
   **/
  KPMatrix *matrix () {return kmatrix;}
  


  /**
   * Move the plot.
   **/
   virtual void moveTo(int x, int y);

  /**
   * Move the plot.
   **/
   virtual void moveBy(int dx, int dy);

   /**
    * Add an X axis.
    **/
   void addXAxis (void);

   /**
    * Add an X axis.
    **/
   void addYAxis (void);


   KPSAxis *xAxis (void) { return xaxis; }
   KPSAxis *yAxis (void) { return yaxis; }


   /**
    * Add a coordinate frame.  There's a good chance you don't want
    *  a set of axes _and_ a coordinate frame.
    *
    * @return The coordinate frame object.
    **/
   KPSCoordFrame *addCoordFrame (void);

   KPSCoordFrame *coordFrame (void) { return cframe; }

   /**
    * Remove a child KPSprite. (see KPSprite::removeChild())
    **/
   void removeChild (KPSprite *child);

   /**
    * Returns the coordinates used for plotting.  If you make changes
    *  you should update the plot.
    **/
   KPCoords *coords () {return &kcoords;}
 
   /**
    * Sets the coordinates used for plotting.
    **/
   void setCoords (const KPCoords &, bool usedefaultticks=true);
  
   /**
    * Draw a frame around the plot?
    **/
   void setDrawFrame (bool _enable) { bframe = _enable; }

   /**
    * Are we drawing a frame around the plot?
    **/
   bool drawFrame (void) { return bframe; }
    


   /**
    * I am a KPS2D.
    **/
   virtual int whatami() const =0;// { return RTTI_KPS2D; }

 protected:
   bool bneedredraw;

   KPS2D() {}
   
   /**
    * This is internal.  It handles the no-hang plot redrawing.
    **/
    void draw (QPainter&);
    /**
     * Reimplement this to draw your plot.
     * You should follow an example and use the function
     *  needRedraw().
     **/
    virtual void reDraw (QPainter *){}


   /**
    * You should call this default version at the end of your
    *  reimplemented version.
    **/
   virtual void setRect();
   
   /**
    * You should call this default version at the end of your
    *  reimplemented version.
    **/
   virtual void resizeEvent (QResizeEvent *);

   /**
    * Call this to see if you need to redraw.
    * NOTE: KPS2D may set this to TRUE, but never to FALSE,
    *  you must do that after you have actually redrawn the plot.
    **/
   bool needRedraw (void) { return bneedredraw; }

   /**
    * Call this when you are done redrawing.
    **/
   void doneRedrawing (void) { bdoneredrawing = TRUE; }


   protected slots:
   void slotSnappyRedraw ();

 private:
   bool bframe;
   bool bdoneredrawing;
   bool bmiddleofredraw;
   KPMatrix *kmatrix;
   KPCoords kcoords;
   QRect arect; //area for plot (not including axes, etc.)

   QPainter *paintbuffer;
   QPixmap *buffer;

   QTimer *qtredraw;

   KPSAxis *xaxis, *yaxis;
   KPSCoordFrame *cframe;

   void basicInit (const KPCoords &, KPMatrix *_matrix);
   void setARect (void);

   QPainter *beginRedraw (void);
};


#endif


