//handle odd/even sizes differently -- have an offset and width

#include <stdio.h>

#include <qfont.h>
#include <qpopupmenu.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kputil.h>

#include "kpsaxis.moc"
#include "kps2d.h"


KPSAxis::KPSAxis (KPView *_view, KPCoords *_coords, Axis _axis,
		  int _z)
  : KPSprite (_view, 0, 0, 0, 0, _z)
{
  printf ("KPAxis\n");
  axis = _axis;
  kcoords=_coords;

  //  setRect();  -- don't put this back!

  decplaces = 2; //configurable later

  pointsize0 = .02;
  axissize0 = .001;
  bboxsize0 = .01;
  ticksize0 = .011;

  if (axis==X)
    setMovableX(FALSE);
  else
    setMovableY(FALSE);

  blabels = bticks = TRUE;

  //You need to call setRect() in the constructor.  KPSprite
  // can't do that for you.


  computeSizes();
  setRect();
}

void
KPSAxis::computeSizes (void)
{
  int newps = (int) (pointsize0 * view()->width());
  printf ("cs: newps = %d\n",newps);
  tickfont.setPointSize (newps);

  axissize = kpmax ((int) (axissize0 * view()->width()),1);
  bboxsize = kpmax ((int) (bboxsize0 * view()->width()),1);
  ticksize = kpmax ((int) (ticksize0 * view()->width()),1);

  computeTextSize();

  if (axis == X)
    igirth = 2*bboxsize + tickxh;

  if (axis == Y)
    igirth = 2*bboxsize + tickyw;
}
void
KPSAxis::computeTextSize(void)
{
  int max;
  int max2;

  QString tick;
  QWidget qwt;
  QPainter p(&qwt);
  QRect r;

  p.setFont(tickfont);

  if (axis==Y)
    {
      max = max2 = 0;
      
      for (double y = kcoords->cymin(); y<kcoords->cymax();
	   y+=kcoords->yTickSpacing())
	{
	  tick.setNum (y,'f',decplaces); 
	  r = p.boundingRect(QRect(0,0,0,0), 0, tick); 
	  if (r.width()>max)
	    max = r.width();
	  if (r.height()>max2)
	    max2 = r.height();
	}
      tickyw = max;
      tickyh = max2/2;
    }

  if (axis==X)
    {
      max= max2 = 0;
      for (double x = kcoords->cxmin(); x<=kcoords->cxmax();
	   x+=kcoords->xTickSpacing())
	{
	  tick.setNum (x,'f', decplaces); 
	  r = p.boundingRect(QRect(0,0,0,0), 0, tick); 
	  if (r.width()>max)
	    max = r.width();
	  if (r.height()>max2)
	    max2 = r.height();
	}
      tickxw = max/2;
      tickxh = max2;
    }
}
void
KPSAxis::setRect()
{
  removeFromChunks();

  if (axis == X)
    brect = QRect (kcoords->oX0() - tickxw,
		   kcoords->yc_to_o (kcoords->ccrossy()) 
		   - bboxsize,
		   kcoords->owidth() + 2*tickxw,
		   2*bboxsize + tickxh);
  else
    brect = QRect (kcoords->xc_to_o (kcoords->ccrossx()) 
		   - bboxsize - tickyw,
		   kcoords->oY0() - tickyh,
		   2*bboxsize + tickyw,
		   kcoords->oheight() + 2*tickyh);
  /*
  printf ("AXSR  %d %d %d %d   %f %f  %d %d\n",
	  brect.x(), brect.y(),brect.width(), brect.height(),
	  kcoords->ccrossx(),
	  kcoords->ccrossy(), kcoords->oheight(), kcoords->cymin());
  */
  lx = (double)brect.x()/view()->width();
  ly = (double)brect.y()/view()->height();

  addToChunks();
}      

void
KPSAxis::draw (QPainter &painter)
{

  QRect r;

  painter.setFont (tickfont);

  if (axis == X)
    {
      //X Axis
      painter.fillRect (x() - axissize,
			kcoords->yc_to_o (kcoords->ccrossy()),
			width(),
			2*axissize,
			Qt::black);

      //X Ticks
      int ty = brect.y()+bboxsize + tickxh;
      QString tick;

      for (double x = kcoords->cxmin(); x<=kcoords->cxmax();
	   x+=kcoords->xTickSpacing())
	{
	  tick.setNum (x,'f', decplaces); 
	  r = painter.boundingRect(QRect(0,0,0,0), 0, tick); 
	  if (blabels)
	      painter.drawText (kcoords->xc_to_o(x) - r.width()/2,
				ty, tick);
	  if (bticks)
	      painter.fillRect (kcoords->xc_to_o(x) - axissize,
				kcoords->yc_to_o (kcoords->ccrossy()) 
				- ticksize,
				2*axissize,
				2*ticksize, 
				Qt::black);
	}
		
    }
  else
    {
      // Y Axis
      painter.fillRect (kcoords->xc_to_o (kcoords->ccrossx()),
			y() - axissize,
			2*axissize,
			height(), 
			Qt::black);

      
      //Y Ticks
      int tx;
      QString tick;

      const int fudgefactor = 2;

      for (double y = kcoords->cymin(); y<=kcoords->cymax();
	   y+=kcoords->yTickSpacing())
	{
          tick.setNum (y,'f',decplaces); 
	  r = painter.boundingRect(QRect(0,0,0,0), 0, tick);
	  tx = kcoords->xc_to_o (kcoords->ccrossx())-ticksize
	    - fudgefactor - r.width();
	  if (blabels)
	    painter.drawText (tx, kcoords->yc_to_o(y) + r.height()/2
			      - fudgefactor,
			      tick );

	  if (bticks)
	    painter.fillRect (kcoords->xc_to_o (kcoords->ccrossx())
			      - ticksize,
			      kcoords->yc_to_o(y) - axissize,
			      2*ticksize,
			      2*axissize, 
			      Qt::black);

	}
    }
			
  if (selected())
    {
      painter.setPen (DashLine);
      painter.setRasterOp (NotROP);
      painter.drawRect (brect);
    }
}

void
KPSAxis::resizeEvent (QResizeEvent *r)
{
  computeSizes();

  setRect();

  KPSprite::resizeEvent  (r);
}


void
KPSAxis::moveTo (int x, int y)
{
  if (view()->userManeuver())
    {
      //      printf ("MT  %d %d\n",x,y);
      if (axis == X)
	kcoords->setCCrossy (kcoords->yo_to_c (y + bboxsize));
      else
	kcoords->setCCrossx (kcoords->xo_to_c (x + bboxsize + tickyw));
      //      printf ("MT2 %f %f  (%d %d)\n",	      kcoords->ccrossx(), kcoords->ccrossy(), bboxsize, tickyw);
    }

  KPSprite::moveTo (x,y);
}


void
KPSAxis::installDefaultRMBMenu (void)
{

  rmbmenu = new QPopupMenu;
  rmbmenu->insertItem ("&Coordinates...", this, SLOT(slotCoords()));

}

void
KPSAxis::slotCoords()
{
  QDialog d (0, 0, TRUE);
  QGridLayout *layout = new QGridLayout (&d, 2, 3, 10);
 
  KPCoordsProp *p = new KPCoordsProp (kcoords, &d);
  layout->addMultiCellWidget (p, 0, 0, 0, 2);
  QPushButton *b = new QPushButton ("OK", &d);
  b->setMinimumSize (b->size());
  b->setMaximumSize (b->size());
  b->setDefault(true);
  connect ( b, SIGNAL (clicked()),
            &d, SLOT (accept()) );
  layout->addWidget (b, 1, 1);
  b = new QPushButton ("Cancel", &d);
  b->setMinimumSize (b->size());
  b->setMaximumSize (b->size());
  connect ( b, SIGNAL (clicked()),
            &d, SLOT (reject()) );
  layout->addWidget (b, 1, 2);

  if (d.exec())
    {
      if (parent()) //must be a KPS2D for now
	{
	  ((KPS2D *)parent())->setCoords (KPCoords (p), false);
	  update();
	}
      else
	*kcoords = * (new KPCoords (p));
    }
}

