/*
 * KPSprite
 * An base class for moveable (resizeable?) objects which are placed
 * on a KPView.
 *
 * Code derived from QwTextSprite by Warwick Allison (warwick@troll.no)
 */

#ifndef __KPSPRITE_H__
#define __KPSPRITE_H__

#include <QwSpriteField.h>
#include <qobject.h>

class KPView;
class QWidget;
class QPopupMenu;
class QTimer;

class KPSprite : public QObject, public QwSpriteFieldGraphic
{
  Q_OBJECT

  friend KPView;

public:
  /**
   * The sprite is movable and unselected upon default construction.
   * Your constructor should call setRect() (probably as it's last
   *  thing).
   **/
  KPSprite(KPView *view, 	   double x, double y, double w, double h, int z=0);

    /**
     * Sets the X-position of the bottom-left corner of the sprite.
     */
    void x(int);
    /**
     * Sets the Y-position of the bottom-left corner of the sprite.
     */
    void y(int);
    /**
     * Sets the Z (altitude) of the sprite.
     */
    void z(int);

    /**
     * Get the width of the sprite.
     **/
    int width (void) { return brect.width(); }

    /**
     * Get the width of the sprite.
     **/
    int height (void) { return brect.height(); }


    /**
     * Moves sprite by the given displacements.
     */
    virtual void moveBy(int dx, int dy);

    /**
     * Sets the position of the bottom-left corner of the sprite.
     */
    virtual void moveTo(int x, int y);

    /**
     * Return the X-position of the bottom-left corner of the sprite.
     */
    int x() const { return brect.x(); }
    /**
     * Return the Y-position of the bottom-left corner of the sprite.
     */
    int y() const { return brect.y(); }

    /**
     * Return the altitude of the sprite.
     */
    int z() const { return alt; }

    /**
     * Return the bounding rectangle.
     **/
    virtual const QRect& boundingRect() { return brect; }

    /**
     * Updates the sprite by calling the update method of
     *  KPView.  This will update the field and then display it.
     **/
    void update (void);
    

    /**
     * Is this sprite movable (by the user) in X?
     **/
    bool movableX (void) {return bmovableX;}

    /**
     * Is this sprite movable (by the user) in Y?
     **/
    bool movableY (void) {return bmovableY;}

    /**
     * Enable/disable movement of the sprite in X by the user.
     **/
    void setMovableX (bool enable) {bmovableX = enable;}

    /**
     * Enable/disable movement of the sprite in Y by the user.
     **/
    void setMovableY (bool enable) {bmovableY = enable;}


    /**
     * For collision detection.
     */
    virtual bool at(int, int) const;
    /**
     * For collision detection.
     */
    virtual bool at(const class QRect &) const;


    /**
     * Which view are we on?
     **/
    KPView * view (void) { return kview; }

    /**
     * Run-Time Type Identification
     * Implement and return the value which identifies the subclass type
     * (if needed).
     **/
    virtual int whatami() const { return 0;}

    /**
     * Add a child sprite.
     * My children will move with me.  (They aren't necessarily on
     *  top of me -- sprites are transparent!)
     **/
    virtual void addChild (KPSprite *);
    
    /**
     * Remove a child sprite.
     * Non-children are ignored.  Sprite is not deleted.
     **/
    virtual void removeChild (KPSprite *);

   /**
    * Tells sprite to generate output suitable for postscript printing.
    **/
   void doPostscript (bool yes=TRUE) { bps = yes; }

    /**
     * Returns the currently installed rmbmenu, or zero if none.
     *  You many installDefaultRMBMenu(), get a pointer to it with
     *  this method, then tailor the menu to your liking.
     **/
   QPopupMenu *rmbMenu (void) { return rmbmenu; }

   /**
    * This is the properties widget.  You can place it on a 
    *  QDialog or QTabDialog for use.  Return zero if none is
    *  available.
    **/
   virtual QWidget *propWidget (void) { return 0L; };

   /**
    * Installs a context (right-mouse-button) menu.
    *  This will replace the current menu.
    * You can pass 0 to diable the context menu.
    **/
   void installRMBMenu (QPopupMenu *);

    /**
     * Installs the default context menu (if there is one.)
     * The default implementation provides no menu.
     *
     * If you implement this, you should place the menu in rmbmenu.
     **/
   virtual void installDefaultRMBMenu (void);

    /**
     * Deletes children, removes from field,  and frees memory used by
     *  this sprite.
     **/
    ~KPSprite();

    public slots:
    /**
     * Connect your popup menu signal to this slot, then
     *  connect the signal "popupRedirect (KPSprite *, int id)"
     *  to your own slot for processing.
     * Ex: You have multiple text label sprites and they all need a
     *  "Change" entry on their context menus.  This systems lets you
     *  know which text sprite is supposed to be changed.
     **/
    void slotPopupRedirect (int id);

 signals:
    void popupRedirect (KPSprite *, int id);

protected:
    bool bps;

    KPSprite () {}

    /**
     * Toggles visibility.
     */
    virtual void makeVisible(bool yes);




   /**
    * Should I be painting postscript-style?
    * (Ask this in draw().)
    **/
   bool postscript (void) { return bps; }


    /**
     * Implement to draw the sprite.
     */
   virtual void draw(QPainter &){}

    /**
     * Call this either side of X(), Y(), or Image() value changes.
     */
    virtual void addToChunks();
    /**
     * Call this either side of X(), Y(), or Image() value changes.
     */
    virtual void removeFromChunks();

    /**
     * Implement this.  Set brect (a QRect) to the size of the
     *  rectangle you will need at the current position (x(),y()).
     *  You should start with 'removeFromChunks()' and end with
     *  'addToChunks()'.
     **/
    virtual void setRect(){}

    
    /**
     * The mouse was pressed in your region.
     * You should call the default one when your implementation is 
     *  through to handle the RMB popup.
     **/
    virtual void mousePressEvent (QMouseEvent *m);

    /**
     * The mouse was released in your region.
     **/
    virtual void mouseReleaseEvent (QMouseEvent *m) {}

    /**
     * This is a GLOBAL (whole-field) resize
     *  event.  
     **/
    virtual void resizeEvent (QResizeEvent *);

    /**
     * This is called after the widget is initialized, but before it
     *  is shown for the first time.
     **/
    virtual void creationEvent (void) {}

    /**
     * Are we a "selected" object?
     **/
    bool selected (void) {return bselected;}
    /**
     * (Un)Selelect this object.
     **/
    virtual void setSelected (bool _selected=TRUE)
      {bselected = _selected;}


    QRect brect, lastaddbrect;
    //These numbers are between zero and one.  They are
    // x,y,w,h as a percentage of the plot width and height.
    double lx, ly, lw, lh;
    double lx0, ly0, lw0, lh0;
    bool bmovableX, bmovableY;
    QPopupMenu *rmbmenu;
    
    /**
     * Tell me who my parent KPSprite is.
     **/
    void setParent (KPSprite *);

 protected:
    /**
     * Returns pointer to parent sprite.
     **/
    KPSprite *parent (void) { return myparent; }

  private:
    void changeChunks();
    int alt;
    bool bselected;
    KPView *kview;
    KPSprite *myparent;

    QList<KPSprite> *children;
};


#endif
