#ifndef __KPVIEW_H__
#define __KPVIEW_H__


#include <qobject.h>
#include <qpixmap.h>
#include <qlist.h>

#include <QwSpriteField.h>
#include <qpopupmenu.h>


class KPSprite;
class KPlotW;
class KPS2D;

class KPView : public QwSpriteFieldView
{
  Q_OBJECT

    friend KPlotW;
    friend KPSprite;

 public:
  KPView (QwSpriteField *field, QWidget *parent, char *name=0);

  QwSpriteField *field (void) const {return qfield;}

  /**
   * The aspect ratio of the sprite field (i.e., the plot)
   *  height/width.
   **/
  double aspectRatio (void) { return aspect; }

  /**
   * Sets an absolute scale for the sprites based on
   *  screen size.
   **/
  double scale (void) {return width()/refwidth;};


  /**
   * This is set if we are in the middle of a user-initiated (GUI)
   *  maneuver. (used for: moving a sprite)
   **/
  bool userManeuver (void) {return busermaneuver;}


   /**
    * Installs an RMB menu for the page.  This will be pulled up when
    *  the user right-clicks on a part of the page which is not covered
    *  by a KPSprite.  You may uninstall by calling installRMB (0).
    **/
   void installRMBMenu (QPopupMenu *);
   
    /**
     * A simple printing interface.  This calls the QPainter::setup()
     *  dialog and then prints then entire view ("page").
     **/
    void print (void);

    /**
     * A simple printing interface.  This calls the QPainter::setup()
     *  dialog and then prints then entire view ("page").  Drafts
     *  will generally print more quickly, but with lower quality.
     **/
    void printDraft (void);

    /**
     * Call this to receive singals telling you where on the
     *  view the mouse is.
     **/
   void  setEmitMouseMove (bool enable=TRUE);

   /**
    * Turn on/off the coordinate-zoom tool.
    **/
   void zoomTool (bool on);

   /**
    * Returns a pointer to the sprite with the focus.
    **/
   KPSprite *focused (void) { return focus_sprite; }

  ~KPView();

 signals:
  /**
   * If you have called setEmitMouseMove (TRUE), then you'll get 
   *  these signals.
   **/
  void mouseAt (int x, int y);

 protected:

  int offsetx, offsety;
  QwSpriteField *qfield;
  KPSprite *grabbed_sprite;
  bool emitMMsignals;
  bool bobj;

  virtual void mousePressEvent ( QMouseEvent * );
  virtual void mouseReleaseEvent ( QMouseEvent * ); 
  virtual void mouseMoveEvent ( QMouseEvent * );
  virtual void resizeEvent ( QResizeEvent * );

  /**
   * A sprite calls this when it is leaving the view (page).
   **/
  void spriteLeaving (KPSprite *);

 protected slots:
    /**
     * This is used internally to help create a smooth animated resizing 
     *  effect.
     **/
    void slotResize ();
 signals:
  void zoomedRect (QRect);

 private:
  double aspect;
  double refwidth;

  KPSprite *focus_sprite;

  QTimer *qtresize;
  QPixmap *qpmresize;
  QWidget *qwresize;
  QResizeEvent *qrresize;
  QPopupMenu *rmb;

  //Sometimes we move KPSprites around to set them up correctly,
  // then this should be FALSE.  If the user is asking them to be
  // repositioned, then this should be TRUE.  The user wants to affect the
  // meaning of the plot, not the expression of the plot (as we do).
  //  (ex., where the axes should cross).
  bool busermaneuver;


  QPoint zoomstart, zoomend;
  bool zoomrect, zoomtool, zoomsel;
};

#endif
