/***************************************************************************
                          addsetilocdlg.cpp  -  description
                             -------------------
    begin                : Sat Oct 30 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "addsetilocdlg.h"

AddSetiLocDlg::AddSetiLocDlg(QWidget *parent, const char *name) : KDialog(parent,name,true,WStyle_Customize|WStyle_DialogBorder)
	{
	setFixedSize(360, 300);
  QGroupBox_1= new QGroupBox(this);
  QGroupBox_1->setGeometry(10,10,340,250);

  QLineEdit_1= new QLineEdit(this);
  QLineEdit_1->setGeometry(20,80,280,20);
  connect(QLineEdit_1,SIGNAL(textChanged(const QString&)),this, SLOT(handleText(const QString&)));

  QPushButton_1= new QPushButton(this);
  QPushButton_1->setGeometry(310,80,30,20);
  QPushButton_1->setText(i18n("..."));
  connect(QPushButton_1, SIGNAL(clicked()), this, SLOT(getDir()));

  QLabel_1= new QLabel(this);
  QLabel_1->setGeometry(20,60,180,20);
  QLabel_1->setText(i18n("Seti@home Directory:"));

  KColorButton_1= new KColorButton(this);
  KColorButton_1->setGeometry(20,215,100,30);
  KColorButton_1->setColor(QColor(255, 0, 0));

  QLabel_2= new QLabel(this);
  QLabel_2->setGeometry(20,195,100,20);
  QLabel_2->setText(i18n("Color:"));

  QPushButton_2= new QPushButton(this);
  QPushButton_2->setGeometry(160,270,80,24);
  QPushButton_2->setText(i18n("OK"));
  connect(QPushButton_2, SIGNAL(clicked()), this, SLOT(ok()));
  QPushButton_2->setEnabled(false);

  QPushButton_3= new QPushButton(this);
  QPushButton_3->setGeometry(270,270,80,24);
  QPushButton_3->setText(i18n("Cancel"));
  connect(QPushButton_3, SIGNAL(clicked()), this, SLOT(reject()));

  QLineEdit_2= new QLineEdit(this);
  QLineEdit_2->setGeometry(20,35,170,20);
  connect(QLineEdit_2,SIGNAL(textChanged(const QString&)),this, SLOT(handleText(const QString&)));

  QLabel_3= new QLabel(this);
  QLabel_3->setGeometry(20,15,160,20);
  QLabel_3->setText(i18n("Description:"));

  QLineEdit_4 = new QLineEdit(this);
  QLineEdit_4->setGeometry(20,125,280,20);

  QLabel_4= new QLabel(this);
  QLabel_4->setGeometry(20,105,280,20);
  QLabel_4->setText(i18n("Command Line Arguments:"));
	
  QCheckBox_1 = new QCheckBox(this);
  QCheckBox_1->setGeometry(20,145,280,24);
  QCheckBox_1->setText(i18n("Invoke SETI@home Client at Start-up?"));
	
  QCheckBox_2 = new QCheckBox(this);
  QCheckBox_2->setGeometry(20,170,280,24);
  QCheckBox_2->setText(i18n("Enable logging of work units?"));
	}

AddSetiLocDlg::~AddSetiLocDlg(){
}

void AddSetiLocDlg::getDir()
	{
	QString d = KFileDialog::getExistingDirectory();
	if(!d.isNull()) setDir(d);
	}

void AddSetiLocDlg::setDir(QString d)
	{
  QLineEdit_1->setText(d);
	}

void AddSetiLocDlg::handleText(const QString& t)
	{
	QString l1 = QLineEdit_1->text();
	QString l2 = QLineEdit_2->text();
	if(l1.isEmpty() || l2.isEmpty())
	  QPushButton_2->setEnabled(false);
	else
	  QPushButton_2->setEnabled(true);	
	}

void AddSetiLocDlg::ok()
{
QDir d((const char *)QLineEdit_1->text());
if(d.exists())
	accept();
else
 	KMessageBox::error(this, "Directory not found.\n"
                           "Make sure to enter a valid\n"
                           "Seti@Home directory.");
}
