/***************************************************************************
                          datainfo.cpp  -  description
                             -------------------
    begin                : Tue Oct 26 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <qtimer.h>
#include <qheader.h>

#include "datainfo.h"
#include "setiloc.h"
#include "ksetiwatch.h"

// extern globals
extern QList<SetiLoc> SetiList;
extern SkyMap *SKYMAP;
extern bool	SKYMAP_LOADED;
extern bool	SKYMAP_VISIBLE;
extern QTimer* RefreshTimer;
extern int RefreshInterval;
extern bool DRAWGRID;

DataInfoListViewItem::DataInfoListViewItem(QListView* parent):QListViewItem(parent)
{
}

DataInfoListViewItem::~DataInfoListViewItem()
{
}

/** Returns a string which is used for sorting the items. */
QString DataInfoListViewItem::key(int column, bool ascending) const
{
// return value must be static
static QString ret;
QString val;
double tmp;

if(column == 4)
	{
	val = text(column);
	tmp = val.toDouble();
	val.sprintf("%f", tmp);
	ret = val.rightJustify(12, '0');
	}
else
	{
	ret = text(column);
	}
	
return(ret);
}

void DataInfoListViewItem::paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align)
{
QListViewItem::paintCell(p, cg, column, width, align);
if(DRAWGRID)
	{
	p->setPen( cg.midlight() );
	p->moveTo(0, height()-1);
	p->lineTo(width-1, height()-1);
	p->lineTo(width-1, 0);
  }
}


DataInfo::DataInfo(QPixmap *starmap, QWidget *parent, const char *name) : QWidget(parent,name)
	{
	TableColumn ditc[] =	{
												{i18n("Location"), 60, AlignLeft},
												{i18n("From"), 170, AlignRight},
												{i18n("Recorded On"), 170, AlignRight},
												{i18n("Source"), 120, AlignRight},
												{i18n("Base Frequency"), 100, AlignLeft}
												};
		
	sm = starmap;
	
  QListView_1= new popListView(this);
  QListView_1->setPopupStyle(popListView::ShowAnywhere);
  QListView_1->move(5,1);

  for(int i=0;i<5;i++)
  	{
  	QListView_1->addColumn(ditc[i].text,-1);
  	QListView_1->setColumnWidth(i, ditc[i].width);  	
	  QListView_1->setColumnAlignment(i, ditc[i].alignment);
	  }
  	
  QPushButton_1= new QPushButton(this);
  QPushButton_1->setGeometry(10,100,80,25);
  QPushButton_1->setText(i18n("Sky Map"));
  connect(QPushButton_1, SIGNAL(clicked()), SLOT(showMap()));

  connect(QListView_1->header(), SIGNAL(sectionClicked(int)), SLOT(toggleSorting(int)));
  sortingorder = true;

	for(SetiLoc* loc=SetiList.first(); loc != 0; loc=SetiList.next() )
		{
  	if(loc->item(SetiLoc::DataInfoList) == 0)
  		{
			loc->addItem(SetiLoc::DataInfoList, QListView_1);
			}
		}	
	refreshList();
	}

DataInfo::~DataInfo()
{
}

void DataInfo::resizeEvent(QResizeEvent *e)
	{
	QListView_1->resize(this->width()-10, this->height()-QPushButton_1->height()-5);
	QPushButton_1->move(5, QListView_1->y()+QListView_1->height()+2);
	}
	
void DataInfo::refreshList()
{
SetiLoc *loc;

// stop the timer during refresh
RefreshTimer->stop();
for( loc=SetiList.first(); loc != 0; loc=SetiList.next() )
	{
	if(loc->item(SetiLoc::DataInfoList) == 0) loc->addItem(SetiLoc::DataInfoList, QListView_1);
	loc->refresh(SetiLoc::DataInfoList);
	}
// restart the timer
RefreshTimer->start(RefreshInterval, FALSE);
}

void DataInfo::showMap()
{
if(SKYMAP_LOADED == true)
	{
 	if(sm->isNull() == false && SKYMAP_VISIBLE == false)
 		{
 		SKYMAP = new SkyMap(sm);
		SKYMAP_VISIBLE = true;
 		SKYMAP->show();
 		}
 	else if(SKYMAP->isActiveWindow() == false)
		{
		SKYMAP->show();
		SKYMAP->raise();
		}
	SKYMAP->clearMap();
	for(SetiLoc *loc=SetiList.first(); loc != 0; loc=SetiList.next() )
		{
		SKYMAP->addLocation(loc);
		}
	SKYMAP->repaint();
 	}
else
 	{
 	KMessageBox::sorry(topLevelWidget(), i18n("Couldn't load the pixmap file."));
 	}
}	

/**  */
void DataInfo::toggleSorting(int column)
{
sortingorder = !sortingorder;
QListView_1->setSorting(column, sortingorder);
}
