/***************************************************************************
                          skymap.h  -  description
                             -------------------
    begin                : Fri Nov 12 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SKYMAP_H
#define SKYMAP_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qscrollview.h>
#include <qlist.h>

#include <kpopupmenu.h>

#include "setiloc.h"
#include "main.h"
/**
  *@author Gordon Machel
  */

class SkyPic : public QWidget
{							

Q_OBJECT
public:
	SkyPic(QWidget* parent=0, const char* name=0);
	~SkyPic();
  void addLocation(SetiLoc* loc);
  void addLocation(SetiLoc* loc, const QString& time_rec, double ra, double dec);
  /**  */
  void clearPic();

protected:
	enum popupIds {ShowText, SmallMarker, NormalMarker, LargeMarker, FillMarker};
	virtual void paintEvent(QPaintEvent *e);
  /** handle mouse press events in the skymap window */
  virtual void mousePressEvent(QMouseEvent *e);
	void displayLocation();
	QList<SkyPos> SeLi;
  /**  */
  KPopupMenu *pic_options;

protected slots:
  /** updates the check items in the popup menu */
  void checkPopupStatus();
  /** handles the selection of a specific popup item
	 * @param id: identifier of chosen item
	 */
  void handlePopupCommand(int id);

public slots: // Public slots
  /** Updates the locations and redraws the map. */
  void updateLocation(SetiLoc* loc);

};

class SkyMap : public QWidget
{
Q_OBJECT
	
public:
	SkyMap(QPixmap* sm, QWidget* parent=0, const char* name=0);
	~SkyMap();
  /**  */
  void addLocation(SetiLoc* loc);
  void addLocation(SetiLoc* loc, const QString& time_rec, double ra, double dec);
  /** clears the list of added locations and redraws the skymap */
  void clearMap();

protected:
	virtual void resizeEvent(QResizeEvent* e);
	virtual void closeEvent(QCloseEvent* e);
  /**  */
  virtual void paintEvent(QPaintEvent* e);
	void displayLocation(QPixmap* sm);
	SkyPic* pic;
	QScrollView* view;
	QPixmap* pm;

};

#endif
