/***************************************************************************
                          csvdatabase.h  -  description
                             -------------------
    begin                : Thu Dec 16 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSVDATABASE_H
#define CSVDATABASE_H

#include <qfile.h>
#include <qstring.h>
#include <qstrlist.h>

/**
  *@author Gordon Machel
  */

class CSVDataBase : public QFile
{
public:
	/**
		* Initialize access to a csv data base.
		* @param: pointer to file name
		*/
	CSVDataBase(const char *file=0);
	/**
		* The destructor.
		*/
	~CSVDataBase();
	/**
	  * Reads an item from column "identifier" and line line.
	  * @param identifier pointer to identifier string
	  * @param line line number
	  * @return QString containing the item
	  */
	QString readItem(const char* identifier, int line);
	/**
		* Same as above, but column is given by an integer number.
		* @param column: column number
		* @param line: line number
		* @return QString containing the item
		*/
	QString readItem(int column, int line);
	/**
		* Extracts an item from the string line, which has been read e.g. by
		* readLine( line ).
		* @param column: column number
		* @param linestr: pointer to string with line
		* @return QString containing the item
		*/
	QString readItem(int column, const char *linestr);
	/**
		* Extracts an item from the string line, which has been read e.g. by
		* readLine( line ).
		* @param identifier: identifier string
		* @param linestr: pointer to string with line
		* @return QString containing the item
		*/
	QString readItem(const char *identifier, const char *linestr);
  /** Returns the number of columns. */
  int columnCount();

protected:
	/**
		* Reads all items of the given line and stores them in a string list.
		* @param linestr pointer to line string
		* @param strlist pointer to string list
		* @return the number of found items
		*/
	int readItems(const char* linestr, QStrList* strlist);
	/**
	  * Reads the definition line.
	  * @return the number of columns
	  */
	int readDefinitionLine();
	/**
	  * Reads the line line.
	  * @return the number of columns
	  */
	int readCurrentLine(int line);
	/**
		* Returns a complete line.
		* @param line: line number
		* @return QString containing the line
		*/	
	QString readLine(int line);
	/**
		* Returns the next line with regard to the current file index.
		* @return QString containing the line
		*/	
	QString readNextLine();
	
protected:
	QString definitionLine;
	QStrList defentries;
	QString currentLine;
	QStrList currententries;
	int currentLineNr;
  int currentLineColumns;
	int columns;

};

#endif
