/***************************************************************************
                          poplistview.h  -  description
                             -------------------
    begin                : Thu Oct 28 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POPLISTVIEW_H
#define POPLISTVIEW_H

#include <qlistview.h>

#include <kpopupmenu.h>

/**
  *@author Gordon Machel
  */

class popListView : public QListView
{
Q_OBJECT

public: 
	popListView(QWidget *parent, const char *name=0);
	~popListView();
  /** Adds an item at root level.
   * @param aName The name to show in the view.
   * @param iconType What kind of icon should be shown.
   */
  QListViewItem *insertRootItem( const QString& aName, QPixmap *icon=0 );
  /** Adds an item with the selected icon.
   * @param aName The name to show in the view.
   * @param iconType What kind of icon should be shown.
   * @param parent Which parent should this item be added to.
   */
  QListViewItem *insertChildItem(const QString& aName, QPixmap *icon=0,
																	 QListViewItem *parent=0 );
	void clear();
	/** Adds an item to the popup menu.
	 * @param name  The text in the popup menu.
	 * @param id    The id number of the item.
	 * @param index An index. If -1, the item will be appended to the menu.
	 * @return The id number.
	 */
  int insertPopupItem(const QString& name, int id=-1, int index=-1);
  /**  */
  int insertPopupItem(const QString& name, QPopupMenu* pop, int id=-1, int index=-1) ;
  inline void insertSeparator() {if(popup) popup->insertSeparator();}
  /** Sets the title of the KPopup menu. */
  inline void popupSetTitle(const QString& title) {if(popup) popup->setTitle(title);}
	/** Two different popup styles. */
	enum PopupStyle {ShowAnywhere, OverItem};	
  /** Returns a pointer to the KPopupMenu object. */
	KPopupMenu* popupMenu();
  /**
   *  Sets the behaviour of the popup menu
   *
   *	@param The new style; can be @c ShowAnywhere to display the popup menu after
   *	a click anywhere in the list, or @c OverItem to display the menu only when the
   *	click occurred over an item
   */
  void setPopupStyle(PopupStyle p);
  /** Returns the current popup style */
  PopupStyle popupStyle();
	
protected:
  /** The last child item added to the tree. */
  QListViewItem *lastChildItem;
  /** The last root-item added to the tree. */
  QListViewItem *lastRootItem;
  /** stores the display style of the popup menu */
  PopupStyle pstyle;
  /** The user-defined popup menu. */
	KPopupMenu* popup;

protected slots:
  /** Handles mouse button clicks correctly. */
	void slotMouseButtonClicked(int but, QListViewItem* it,
                              const QPoint& pos, int col);

};

#endif
