/***************************************************************************
                          skymap.h  -  description
                             -------------------
    begin                : Fri Nov 12 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SKYMAP_H
#define SKYMAP_H

#include <qwidget.h>
//#include <qpixmap.h>
//#include <qscrollview.h>
#include <qlist.h>

#include "setiloc.h"

class KPopupMenu;
class QPixmap;
class QScrollView;

/**
  *@author Gordon Machel
  */

struct SkyPos {
							QString location;
							QString time_recorded;
							QColor  color;
							double  ra;
							double  dec;
							};

class SkyPic : public QWidget
{							
Q_OBJECT

public:
	SkyPic(QWidget* parent=0, const char* name=0);
	~SkyPic();

protected: //methods
	virtual void paintEvent(QPaintEvent *e);
  /** handle mouse press events in the skymap window */
  virtual void mousePressEvent(QMouseEvent *e);

protected: //attributes	
  enum popupIds  {ShowText, SmallMarker, NormalMarker, LargeMarker, FillMarker};
  KPopupMenu*    pic_options;
	QList<SkyPos>* list;

protected slots:
  /** Updates the check items in the popup menu. */
  void checkPopupStatus();
  /** Handles the selection of a specific popup item.
   * @param id: identifier of chosen item
   */
  void handlePopupCommand(int id);
};

class SkyMap : public QWidget
{
Q_OBJECT
	
public:
	SkyMap(QPixmap* sm, QWidget* parent=0, const char* name=0);
	~SkyMap();
  void addLocation(SetiLoc* loc);
  void addLocation(SetiLoc* loc, const QString& time_rec, double ra, double dec);
  /** Clears the list of added locations and redraws the skymap. */
  void clearMap();
  /**  */
  QList<SkyPos>* skyposList() {return(&SeLi);}

protected: // methods
	virtual void resizeEvent(QResizeEvent* e);
	virtual void closeEvent(QCloseEvent* e);

protected slots:
  /** Updates the locations and redraws the map. */
  void updateLocation(WorkUnitData wud, const QString& locname,
                      const QColor& col);

protected: // attributes
	QList<SkyPos> SeLi;
	SkyPic*       pic;
	QScrollView*  view;
};

#endif
