/**********************************************************************

            Last generated: Sat Dec 11 22:13:18 1999

**********************************************************************/
#include "kconfigure.h"
#include "resource.h"
#include "cexecuteargdlg.h"

#include <kprocess.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <kcontainer.h>
#include <kseparator.h>
#include <krestrictedline.h>


/** Search the configure file in the arguments */
void Kconfigure::SearchPath(QString setDIR){

			if(setDIR.find("configure",setDIR.length()-9,false)==-1)
				{
				do
					{
					setDIR=SearchConfigure();
					if(setDIR.isNull()==true && setDirectory.exists()==true) {
									setDIR = setDirectory.currentDirPath()+"/configure";
									break;
									}
					} while(setDIR.isNull());
				}
		LogString->insertList(i18n("Open file : ")+setDIR);
		setDIR.resize(setDIR.length()-9);
		setDirectory.setCurrent(setDIR);
		this->setCaption("kconfigure ("+setDIR+")");
}

/** Search the Configure File */
QString Kconfigure::SearchConfigure(){
	QString initDIR;

	if(setDirectory.exists()) { initDIR = setDirectory.currentDirPath(); } else { initDIR=0; }

	QString fileToOpen = KFileDialog::getOpenFileName(initDIR,
											 "configure",this, i18n("Opening a configure file..."));
	if(fileToOpen.find("configure",fileToOpen.length()-9,true)==-1)
		{
	  return 0;
		}
		else
		{
		return fileToOpen;
		}
}


/** Display Output Messages */
void Kconfigure::slotOutputMessages(KProcess*,char* buffer,int buflen){
  QString str(buffer,buflen);

	output->append(str);

	output->setCursorPosition(output->numLines(),0);
}


/** Display Error Output Messages */
void Kconfigure::slotOutputMessagesError(KProcess*,char* buffer,int buflen){

  QString str(buffer,buflen);
	outputStringError.append(str);

	if(str.find("error",0,false)==-1)
		{ output->append(str); }
		else
		{ FatalError=true; output->append(i18n("<<ERROR>>")+str); }

  output->setCursorPosition(output->numLines(),0);
}


/** Execute a QString */
void Kconfigure::slotAction(QString execF){

  if(q->isRunning()==true){
		KMsgBox::message( this, i18n("I cannot do this !"), i18n("SORRY !\n\nWait until the process finish.\n"), KMsgBox::EXCLAMATION );
		LogString->insertList(i18n("--> Not posible. The last process is not finish."));
		return;
		}

  q = new KShellProcess();
  q->clearArguments();

  output->clear();
	FatalError=false;
	outputStringError=0;

	connect( q, SIGNAL(receivedStdout(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	connect( q, SIGNAL(receivedStderr(KProcess *, char *, int)),this,SLOT(slotOutputMessagesError(KProcess *, char *, int)));

	if(execF.find("help")==-1)
	  connect( q, SIGNAL(processExited(KProcess *)),this, SLOT(slotFinishAction()) );

  *q << execF;
  q->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}

/** When the action finish I will notify the user. */
void Kconfigure::slotFinishAction(){
	if (q->normalExit())
	{
	if(outputStringError.isNull())
													{
		KMsgBox::message( this, i18n("Finish action !"), i18n("OK !\n\nThe process is finish.\n"), KMsgBox::INFORMATION );
  												}
													else
													{
		if(FatalError)
			{
			KMsgBox::message( this, i18n("Finish action !"), i18n("FATAL ERROR.\n\nSee the ouput command to view\nwhat type of errors are.\n"), KMsgBox::EXCLAMATION );
			LogString->insertList(i18n("--> It seems, fatal error?."));
			} else {
			KMsgBox::message( this, i18n("Finish action !"), i18n("OK !\n\nThe process is finish with ERRORS.\n\nIt seems, than you can continue but see the output command to view\nwhat type of errors are.\n"), KMsgBox::EXCLAMATION );
			LogString->insertList(i18n("--> Warnings or errors."));
			}
													}										
	delete q;
	}
	else
	{
	KMsgBox::message( this, i18n("Finish action !"), i18n("SORRY !\n\nThe process did not exit normally.\n"), KMsgBox::EXCLAMATION );
	LogString->insertList(i18n("--> Proccess killed or stopped."));
	}
}

/** Make sure that the file can be install.
	+ Execute su to install the sources.
	*/
void Kconfigure::slotInstall(){
	
  if(q->isRunning()==true){
		KMsgBox::message( this, i18n("I cannot do this !"), i18n("SORRY !\n\nWait until the process finish.\n"), KMsgBox::EXCLAMATION );
		LogString->insertList(i18n("--> Not posible. The last process is not finish."));
		return;
		}

  q = new KShellProcess();

	CExecuteArgDlg argdlg(this,"Arguments",i18n("Make Install"), i18n("Password : "),true);

	  q->clearArguments();
	  output->clear();
		outputStringError=0;
		FatalError=false;

		connect( q, SIGNAL(receivedStdout(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
		connect( q, SIGNAL(receivedStderr(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	  connect( q, SIGNAL(processExited(KProcess *)),this, SLOT(slotFinishAction()) );
		
	  *q << "su --login --preserve-environment ";
		*q << "-c \"cd " + setDirectory.currentDirPath();
		*q << " ; make install\"";

	  q->start(KProcess::NotifyOnExit, KProcess::All);

    argdlg.exec();

		if((argdlg.getArguments()).isNull()==true) { delete q; return; }

		q->writeStdin(argdlg.getArguments(), (strlen(argdlg.getArguments())) );
		q->closeStdin();

		LogString->insertList(i18n("-> Install files"));

}

/** Configure with arguments */
void Kconfigure::slotArguments(){
CExecuteArgDlg argdlg(this,"Arguments",i18n("Configure with Arguments"), i18n("Arguments : "),false);

if(argdlg.exec()){
	slotAction("./configure "+(argdlg.getArguments()));
    }
}

/** Write the config options */
void Kconfigure::writeConfig(){
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Output", output->isVisible());
  config->writeEntry("Show LogWindow", LogString->isVisible());
//  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int) menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
  config->writeEntry("OutputFont", output->font() );
}

/** Read the config options */
void Kconfigure::readConfig(){
  config->setGroup("General Options");

// bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  Menuview->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  if(!bViewToolbar)
  {
     enableToolBar(KToolBar::Hide);
  }

// bar status settings
  bool bViewOutput = config->readBoolEntry("Show Output", true);
  Menuview->setItemChecked(ID_VIEW_OUTPUT, bViewOutput);
  if(!bViewOutput)
  {
		output->hide();
		if( Menuview->isItemChecked(ID_VIEW_TOOLBAR))
			this->resize(this->width(), 50);
			else
			this->resize(this->width(), 25);
  }

// bar status settings
  bool bViewLog = config->readBoolEntry("Show LogWindow", false);
  Menuview->setItemChecked(ID_VIEW_LOGWINDOW, bViewLog);
  if(bViewLog)
  {
		LogString->show();
  }


  // bar position settings
  KMenuBar::menuPosition menuBarPos;
  menuBarPos=(KMenuBar::menuPosition) config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);

  MenuBar->setMenuBarPos(menuBarPos);
  toolBar()->setBarPos(toolBarPos);
	
  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
	QFont font("helvetica",12);
	output->setFont( config->readFontEntry("OutputFont", &font ) );
}

/** Exit the application */
bool Kconfigure::queryExit(){
  writeConfig();
  return true;
}
