/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Oct 11 19:06:52 MEST 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "klock.h"
#include "global.h"

static const char *description = I18N_NOOP("A desktop clock for the KDE");

static const KCmdLineOptions options[] =
{
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "kdclock", I18N_NOOP("KDClock"),
    KLOCK_VERSION, description, KAboutData::License_GPL,
    "(c) 2000, Norbert Andres");
  aboutData.addAuthor("Norbert Andres",0, "NAndres@gmx.de");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KApplication a;
  Klock *klock = new Klock();
  a.setMainWidget(klock);
  klock->show();

  return a.exec();
}
