
/***************************************************************************
                          optionstate.h  -  description
                             -------------------
    begin                : Wed Oct 11 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _OPTION_STATE_H_
#define _OPTION_STATE_H_

#include <kapp.h>
#include <qfont.h>
#include <qdatetime.h>

enum displayModes
{
	dmClock = 0,
	dmCountdown = 1,
	dmStopWatch = 2
};

enum backgroundModes
{
	bmOneColor =0,
	bmTwoColors=1,
	bmPicture=2,
	bmTransparent=3
};

enum pictureModes
{
        pmCentered    = 0,
        pmMaxCentered = 1,
        pmScaled    = 2,
        pmTiled       = 3
};

enum effects{
	eHorizontalGradient=0,
	eVerticalGradient=1,
	ePyramidGradient=2,
	ePipeCrossGradient=3,
	eEllipticGradient=4,
	eDiagonalGradient=5,
	eCrossDiagonalGradient=6,
	eRectangleGradient=7
};

enum pBackground{
	pbOneColor=0,
	pbTwoColors=1,
    pbTransparent=2
};

enum fontStates
{
    fNormal = 0,
    fItalic = 1,
    fBold   = 2,
    fBoldItalic = 3,
    fUnderline = 4,
    fItalicUnderline = 5,
    fBoldUnderline = 6,
    fBOldItalicUnderline = 7
};

struct SModeState
{
	SModeState(void)
	{
		displayMode = dmClock;
		ampm = false;
		enableAlarm = false;
		alarmFile = "";
		countHourMin = "00:00";
		alarmTime = QTime::currentTime();		
	}
	int displayMode;
	QString countHourMin;
	bool ampm;
	bool enableAlarm;
	QString alarmFile;
	QTime alarmTime;
};

struct SFontState
{
	SFontState (void)
	{
		font = QFont ("Courier",20,QFont::Bold);
		fitSize = false;
	}
	QFont font;
	bool fitSize;
};

struct SColorState
{
	SColorState (void)
	{
		foreground = QColor("black");
		shadow = QColor("darkgrey");
		plain = QColor("red");
	}

	QColor foreground;
	QColor shadow;
	QColor plain;
};

struct SBackgroundState
{
	SBackgroundState(void)
	{
		backgroundColor1 = QColor("grey");
		backgroundColor2 = QColor("grey");
		backgroundPicture = "";
		effect = bmOneColor;
		effectNumber = eHorizontalGradient;
		pictureBackground = pbOneColor;
		pictureMode = pmMaxCentered;
	}
	QColor backgroundColor1;
	QColor backgroundColor2;
	QString backgroundPicture;
	int effect;
	int effectNumber;
	int pictureBackground;
	int pictureMode;
};

struct SMiscState
{
	SMiscState (void)
	{
		beep = false;
		showSeconds = true;
		showDate = false;
		showShadow = true;
		blinkingDots = false;
		saveSettings = true;
        dateFontSize = 10;
        dateFontState = 0;
        showDateShadow = false;
        dateShadowDist = 1;
        shadowDist = 3;
	}
    int dateShadowDist;
    int shadowDist;
	bool beep;
	bool showSeconds;
	bool showDate;
    bool showDateShadow;
	bool showShadow;
	bool blinkingDots;
	bool saveSettings;
    int dateFontSize;
    int dateFontState;
};

struct SOptionState
{
	SModeState mode;
	SFontState font;
	SColorState color;
	SBackgroundState back;
	SMiscState misc;
};

#endif






