/***************************************************************************
                          kfilecoder.cpp  -  description                              
                             -------------------                                         
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kfilecoder.h>

#include <qpushbt.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmsgbox.h>
#include <qlistview.h>
#include <qfiledialog.h>
#include <qstrlist.h>
#include <qprogressdialog.h>

#include <kprogress.h>
#include <kmsgbox.h>
#include <kaccel.h>
#include <kiconloader.h>

#include "PassDialog.h"
#include "PropertiesDialog.h"
#include "ExtractDialog.h"
#include "filegest.h"


// ===========================================================================================================================
KFileCoderApp::KFileCoderApp()
{
  setCaption("KFileCoder " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  UpdateCommandsAccess();
}

// ===========================================================================================================================
KFileCoderApp::~KFileCoderApp()
{
  
}

// ===========================================================================================================================
void KFileCoderApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

// ===========================================================================================================================
void KFileCoderApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}

// ===========================================================================================================================
void KFileCoderApp::UpdateCommandsAccess()
{	
	// If archive opened
	if (doc -> IsArchiveOpened() == TRUE)
	{	disableCommand(ID_FILE_NEW);
		disableCommand(ID_FILE_OPEN);
		disableCommand(ID_FILE_OPEN);
		enableCommand(ID_FILE_CLOSE);
		enableCommand(ID_FILE_PROP);
	
		enableCommand(ID_ARCHIVE_ADD);
		enableCommand(ID_ARCHIVE_EXTRACT_ALL);
		enableCommand(ID_ARCHIVE_EXTRACT_SEL);
		enableCommand(ID_ARCHIVE_DELETE);
	}

	// If archive closed
	if (doc -> IsArchiveOpened() == FALSE)
	{	enableCommand(ID_FILE_NEW);
		enableCommand(ID_FILE_OPEN);
		disableCommand(ID_FILE_CLOSE);
		disableCommand(ID_FILE_PROP);
	
		disableCommand(ID_ARCHIVE_ADD);
		disableCommand(ID_ARCHIVE_EXTRACT_ALL);
		disableCommand(ID_ARCHIVE_EXTRACT_SEL);
		disableCommand(ID_ARCHIVE_DELETE);
	}
}

// ===========================================================================================================================
void KFileCoderApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/kfilecoderapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );


	// *-*-*-*-*-*-*-*-*-*- Recent File List *-*-*-*-*--*-*-*-*-*-*-*-*-*-
  recentPop = new QPopupMenu;
  recentPop -> clear();
  for (int i = 0; i < (int) recentFileList.count(); i++)
    recentPop -> insertItem(recentFileList.at(i));

	file_menu->insertItem(i18n("Open &Recent"), recentPop);
  connect( recentPop, SIGNAL(activated(int)), SLOT(slotOpenRecent(int)));
	// *-*-*-*-*-*-*-*-*-*- Recent File List *-*-*-*-*--*-*-*-*-*-*-*-*-*-

  file_menu->insertSeparator();
  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprop.xpm"), i18n("&Properties"), ID_FILE_PROP );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_N, ID_FILE_NEW);
  file_menu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
  file_menu->setAccel(CTRL+Key_W, ID_FILE_CLOSE);
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


	extract_menu = new QPopupMenu();
	extract_menu -> insertItem(Icon("extract.xpm"), i18n("Extract &All"), ID_ARCHIVE_EXTRACT_ALL);
	extract_menu -> insertItem(Icon("extract.xpm"), i18n("Extract &Selected"), ID_ARCHIVE_EXTRACT_SEL);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  archive_menu = new QPopupMenu();
  archive_menu->insertItem(Icon("add.xpm"), i18n("&Add"), ID_ARCHIVE_ADD );
  archive_menu->insertItem(Icon("extract.xpm"), i18n("&Extract"), extract_menu);
  archive_menu->insertItem(Icon("delete.xpm"), i18n("&Delete"), ID_ARCHIVE_DELETE );
 
  //archive_menu key accelerators
  archive_menu->setAccel(CTRL+Key_A, ID_ARCHIVE_ADD);
  archive_menu->setAccel(CTRL+Key_X, ID_ARCHIVE_EXTRACT_ALL);
  archive_menu->setAccel(CTRL+Key_S, ID_ARCHIVE_EXTRACT_SEL);
  archive_menu->setAccel(CTRL+Key_D, ID_ARCHIVE_DELETE);

 
  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  //help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));
  help_menu->insertItem(i18n("KFileCoder &Home page"), ID_HELP_WEBSITE);
  help_menu->insertItem(i18n("&About KFileCoder..."), ID_HELP_ABOUT);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Edit"), archive_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(archive_menu);
  CONNECT_CMD(extract_menu);
  CONNECT_CMD(view_menu);
  CONNECT_CMD(help_menu);

}

// ===========================================================================================================================
void KFileCoderApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File"));

  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File"));
  toolBar()->setDelayedPopup(ID_FILE_OPEN, recentPop);

  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("fileprop.xpm"), ID_FILE_PROP, true, i18n("File Properties"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("add.xpm"), ID_ARCHIVE_ADD, true, i18n("Add"));
  toolBar()->insertButton(Icon("extract.xpm"), ID_ARCHIVE_EXTRACT_ALL, true, i18n("Extract all"));
  toolBar()->insertButton(Icon("delete.xpm"), ID_ARCHIVE_DELETE, true, i18n("Delete"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

// ===========================================================================================================================
void KFileCoderApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

// ===========================================================================================================================
void KFileCoderApp::initView()
{ 
  doc = new KFileCoderDoc(this);

  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  KApplication *app=KApplication::getKApplication();
  view = new QListView(this); //KFileCoderView(app,doc,this);

	setView(view);
  doc -> SetMainWnd(this);
  doc -> SetListView(view);
	
	view -> addColumn(i18n("Name"), 250);
	
	view -> addColumn(i18n("Size"), 100);
	view -> setColumnAlignment(1, 2);

	view -> addColumn(i18n("CRC"), 100);
	view -> setColumnAlignment(2, 2);

	view -> addColumn(i18n("Path"), 200);

	view -> setSorting(-1); // Disable sorting for all columns
	view -> setMultiSelection(TRUE);

	view -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
	view -> setLineWidth(2);
}

// ===========================================================================================================================
bool KFileCoderApp::queryExit()
{
  /*int exit = KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));

  if(exit == 1)
    return true;
  else
    return false; */
	return true;
}

// ===========================================================================================================================
void KFileCoderApp::closeEvent (QCloseEvent *)
{	saveOptions();
	slotFileQuit();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileProperties()
{	PropertiesDialog dlg(doc -> GetArchiveFile(), doc -> GetNbFiles(), doc -> GetAlgoUsed(), this, NULL);
	dlg.exec();
}

// ===========================================================================================================================
void KFileCoderApp::saveOptions()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar", statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

	// Save Recent Open File List
	config->setGroup("Recently Opened Files");
	QString recent_number;
  for(int i = 0; i < (int) recentFileList.count(); i++)
	{	recent_number.setNum(i+1);
		config->writeEntry(recent_number.data(),recentFileList.at(i));
  }
}

// ===========================================================================================================================
void KFileCoderApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);


	// Save Recent Open File List
	QString str;
  recentFileList.clear();
  config->setGroup("Recently Opened Files");
  str = config->readEntry("1", "");
  if (!str.isEmpty() && QFile::exists(str.data()))
    recentFileList.append(str.data());
  str = config->readEntry("2", "");
  if (!str.isEmpty() && QFile::exists(str.data()))
    recentFileList.append(str.data());
  str = config->readEntry("3", "");
  if (!str.isEmpty() && QFile::exists(str.data()))
    recentFileList.append(str.data());
  str = config->readEntry("4", "");
  if (!str.isEmpty() && QFile::exists(str.data()))
    recentFileList.append(str.data());
  str = config->readEntry("5", "");
  if (!str.isEmpty() && QFile::exists(str.data()))
    recentFileList.append(str.data());
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

// ===========================================================================================================================
void KFileCoderApp::slotFileOpen()
{
	char szFilename[MAXPATHLEN];
	char szPassword[MAX_PASSLEN];
	QString strFilename;
	int nRes;

	QFileDialog dlg;
	strFilename = dlg.getOpenFileName("*.kfc");
	if (strFilename.isEmpty())
		return ;

	// Dialog to ask password ==> szPassword
	PassDialog passDlg(this, (const char*) 0);
	nRes = passDlg.exec();
	if (nRes == -1)
		return;
	sprintf (szPassword, "%s", passDlg.GetPassword());

	sprintf (szFilename, "%s", strFilename.data());

	AddRecentFileToList(szFilename);

	nRes = doc -> OpenArchive(szFilename, szPassword);
	if (nRes == -1)
		return;
	
	// Update menu & toolbar commands
	UpdateCommandsAccess();

}

// ===========================================================================================================================
void KFileCoderApp::slotFileNew()
{ char szFilename[MAXPATHLEN];
	char szPassword[MAX_PASSLEN];
	int nAlgorithm;
	QString strFilename;
	int nRes;
	QFileDialog dlg;
	strFilename = dlg.getSaveFileName(0, "*.kfc");
	if (strFilename.isEmpty())
		return ;

	// Force the extension to be "kfc"
	if(strFilename.size() > 3)
	{	QString strExt = strFilename.right(4);
		if (strExt != ".kfc" && strExt.right(1) != ".")
			strFilename += ".kfc";
	}


	// Dialog to ask password ==> szPassword
	PassDialog passDlg(this, (const char*) 0);
	nRes = passDlg.exec();
	if (nRes == -1)
		return;
	sprintf (szPassword, "%s", passDlg.GetPassword());

	// TODO = Dialog to ask Algorithm to use
	nAlgorithm = ALGO_ALG1XOR; // TEMPORARY

	sprintf (szFilename, "%s", strFilename.data());
	AddRecentFileToList(szFilename);

	nRes = doc -> CreateArchive(szFilename, szPassword, nAlgorithm);
	if (nRes == -1)
		return;
	
	// Propose to add files to archive
	slotArchiveAdd();

	// Update menu & toolbar commands
	UpdateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileClose()
{
 	doc -> CloseArchive();
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveAdd()
{	QFileDialog dlg(this);
	QStrList strlFileList;
	int nRes;
	int nPos = 0; // Nb of files added	

	// The user select files to add to archive
	strlFileList = dlg.getOpenFileNames();

	// Draw the progress dialog
	QProgressDialog dlgProgress(i18n("Adding files to archive..."),0, strlFileList.count(), this,"",true);
  dlgProgress.setCaption("KFileCoder");
	dlgProgress.show();
	dlgProgress.setProgress(nPos);

	while (!strlFileList.isEmpty()) // While file list not empty
	{	// Add a file to archive
		nRes = doc -> AddFile(strlFileList.first());
		//if (nRes == -1)	
		//	return;
		strlFileList.removeFirst();
		dlgProgress.setProgress(++nPos);
		if (dlgProgress.wasCancelled())
			break;
	}
	
	// Redraw the List View
	doc -> ListView_Fill();
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveExtractAll()
{
	char szDestPath[MAXPATHLEN];
	int nRes;	

	// Dialog to select the destination directory
	ExtractDialog extractDlg(this, (const char*) 0);
	nRes = extractDlg.exec();
	if (nRes == -1)
		return;

	sprintf (szDestPath, "%s", extractDlg.GetDestinationDirectory());

	doc -> ExtractFiles(szDestPath, false);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveExtractSel()
{
	char szDestPath[MAXPATHLEN];
	int nRes;	

	// Dialog to select the destination directory
	ExtractDialog extractDlg(this, (const char*) 0);
	nRes = extractDlg.exec();
	if (nRes == -1)
		return;

	sprintf (szDestPath, "%s", extractDlg.GetDestinationDirectory());

	doc -> ExtractFiles(szDestPath, true);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveDelete()
{
  doc -> DeleteSelectedFilesInArchive();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KFileCoderApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
void KFileCoderApp::slotFileQuit()
{
  slotFileClose();
  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

// ===========================================================================================================================
void KFileCoderApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

// ===========================================================================================================================
void KFileCoderApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


// ===========================================================================================================================
void KFileCoderApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}

// ===========================================================================================================================
void KFileCoderApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

// ===========================================================================================================================
void KFileCoderApp::slotOpenRecent(int i)
{ QString strFilename;
	char szFilename[MAXPATHLEN];
	char szPassword[MAX_PASSLEN];
	int nRes;

	strFilename = recentFileList.at(i);

	if (strFilename.isEmpty())
		return ;

	// Open the Archive
	
	// Dialog to ask password ==> szPassword
	PassDialog passDlg(this, (const char*) 0);
	nRes = passDlg.exec();
	if (nRes == -1)
		return;
	sprintf (szPassword, "%s", passDlg.GetPassword());

	sprintf (szFilename, "%s", strFilename.data());
	nRes = doc -> OpenArchive(szFilename, szPassword);
	if (nRes == -1)
		return;
	
	// Update menu & toolbar commands
	UpdateCommandsAccess();
}					

// ===========================================================================================================================
void KFileCoderApp::slotHelpWebSite()
{	if(vfork() > 0)
	{ // drop setuid, setgid
    setgid(getgid());
    setuid(getuid());

    execlp("kfmclient", "kfmclient", "exec", QString("http://perso.club-internet.fr/dupoux/sysexp/linux/kfilecod/").data(), 0);
    _exit(0);
  }
}

// ===========================================================================================================================
void KFileCoderApp::slotHelpAbout()
{
  QMessageBox aboutmsg(this, "About KFileCoder");
  aboutmsg.setCaption(i18n("About KFileCoder..."));
  aboutmsg.setButtonText(1, i18n("OK"));
  aboutmsg.setText("\t           KFileCoder version "VERSION" \n\n\n"
                   "Franois Dupoux <fdupoux@lemel.fr>\n\n"
                   "http://perso.club-internet.fr/dupoux/sysexp/linux/kfilecod/\n");

  QPixmap pm;
  pm.load(KApplication::kde_datadir() + "/kfilecoder/pics/about.bmp");
  aboutmsg.setIconPixmap(pm);
  aboutmsg.show();

}

// ===========================================================================================================================
void KFileCoderApp::AddRecentFileToList(char *szFilename)
{
	QString strText;
  int i;

	// Check file in not already in the list
	for (i=0; i < (int) recentFileList.count(); i++)
	{	strText.sprintf("%s", szFilename);		
    if (strText == recentFileList.at(i)) // if file is already in the list
			return ;
  }

  if( recentFileList.count() >= 5)
    recentFileList.remove(4);
	
	recentFileList.insert(0, szFilename);

	// Redraw menu
  recentPop -> clear();
  for (i = 0; i < (int) recentFileList.count(); i++)
    recentPop -> insertItem(recentFileList.at(i));
}

// ===========================================================================================================================
void KFileCoderApp::commandCallback(int id_)
{
  switch (id_)
	{
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_NEW,                 slotFileNew())
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
    ON_CMD(ID_FILE_CLOSE,               slotFileClose())
    ON_CMD(ID_FILE_PROP,                slotFileProperties())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_ARCHIVE_ADD,              slotArchiveAdd())
    ON_CMD(ID_ARCHIVE_EXTRACT_ALL,      slotArchiveExtractAll())
    ON_CMD(ID_ARCHIVE_EXTRACT_SEL,      slotArchiveExtractSel())
    ON_CMD(ID_ARCHIVE_DELETE,           slotArchiveDelete())
  
    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())

    ON_CMD(ID_HELP_WEBSITE,             slotHelpWebSite())
    ON_CMD(ID_HELP_ABOUT,               slotHelpAbout())
  }
}

// ===========================================================================================================================
void KFileCoderApp::statusCallback(int id_)
{
  switch (id_)
	{
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,      i18n("Opens a new application window"))
    ON_STATUS_MSG(ID_FILE_NEW,             i18n("Creates a new archive"))
    ON_STATUS_MSG(ID_FILE_OPEN,            i18n("Opens an existing archive"))
    ON_STATUS_MSG(ID_FILE_CLOSE,           i18n("Closes the actual archive"))
    ON_STATUS_MSG(ID_FILE_PROP,            i18n("Draw informations and properties of the file"))
    ON_STATUS_MSG(ID_FILE_QUIT,            i18n("Exits the program"))

    ON_STATUS_MSG(ID_ARCHIVE_ADD,          i18n("Add files to the archive"))
    ON_STATUS_MSG(ID_ARCHIVE_EXTRACT_ALL,  i18n("Extract all files of the archive"))
    ON_STATUS_MSG(ID_ARCHIVE_EXTRACT_SEL,  i18n("Extract selected files"))
    ON_STATUS_MSG(ID_ARCHIVE_DELETE,       i18n("Delete selected files in the archive"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,         i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,       i18n("Enables / disables the Statusbar"))

    ON_STATUS_MSG(ID_HELP_WEBSITE,         i18n("Go to KFileCoder Home Page"))
    ON_STATUS_MSG(ID_HELP_ABOUT,           i18n("Draw informations about program"))
  }
}





















































































