/***************************************************************************
                          kfilereplaceview.cpp  -  description                              
                             -------------------                                         
    begin                : ven jun 11 17:07:02 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kfilereplaceview.h>
#include "kfilereplace.h"
#include <qdatetime.h>

// ===========================================================================================================================
KFileReplaceView::KFileReplaceView(KApplication* app, KFileReplaceDoc* doc, QWidget *parent): QWidget(parent)
{
	m_app = app;

	// *-*-*-*-*-*-*-*-*-*-* Main Window Widgets -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
	
  // 1) Tab View and Pages
	m_tabctl=new KTabCtl(this, "Pages");
	
	m_Page=new QWidget(m_tabctl,"Files");
	m_tabctl->addTab(m_Page, i18n("Files"));
	m_Page=new QWidget(m_tabctl,"Text");
	m_tabctl->addTab(m_Page, i18n("Text"));
	m_Page=new QWidget(m_tabctl,"Date & Size");
	m_tabctl->addTab(m_Page, i18n("Date & Size"));
	m_Page=new QWidget(m_tabctl,"Options");
	m_tabctl->addTab(m_Page, i18n("Options"));
	m_tabctl->setGeometry(0, 0, 500, 280);

	connect(m_tabctl,SIGNAL(tabSelected(int)),SLOT(slotTabSelection(int)));

	// 2) List View and columns
	m_List = new QListView( this, "listview" );
	m_List->setGeometry(10, 290, 490, 200);
	m_List->setMinimumSize( 0, 0 );
	m_List->setMaximumSize( 32767, 32767 );
	m_List->setFocusPolicy( QWidget::TabFocus );
	m_List->setBackgroundMode( QWidget::PaletteBackground );
	m_List->setFontPropagation( QWidget::NoChildren );
	m_List->setPalettePropagation( QWidget::NoChildren );
	m_List->setMidLineWidth( 0 );
	m_List->QFrame::setMargin( 0 );
	m_List->setResizePolicy( QScrollView::Manual );
	m_List->setVScrollBarMode( QScrollView::Auto );
	m_List->setHScrollBarMode( QScrollView::Auto );
	m_List->setTreeStepSize( 20 );
	m_List->setMultiSelection( FALSE );
	m_List->setAllColumnsShowFocus( FALSE );
	m_List->setItemMargin( 1 );
	m_List->setRootIsDecorated( FALSE );
	m_List->addColumn(i18n("Name"), -1 );
	m_List->setColumnWidthMode( 0, QListView::Maximum );
	m_List->setColumnAlignment( 0, 1 );
	m_List->addColumn(i18n("Directory"), -1 );
	m_List->setColumnWidthMode( 1, QListView::Maximum );
	m_List->setColumnAlignment( 1, 1 );
	m_List->addColumn(i18n("Old size"), -1 );
	m_List->setColumnWidthMode( 2, QListView::Maximum );
	m_List->setColumnAlignment( 2, 2 );
	m_List->addColumn(i18n("New Size"), -1 );
	m_List->setColumnWidthMode( 3, QListView::Maximum );
	m_List->setColumnAlignment( 3, 2 );
	m_List->addColumn(i18n("Nb replaced"), -1 );
	m_List->setColumnWidthMode( 4, QListView::Maximum );
	m_List->setColumnAlignment( 4, 2 );
	m_List->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_List->setLineWidth(2);


	// *-*-*-*-*-*-*-*-*-*-* General Page Widgets -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	m_labelDir = new QLabel( this, "labelDir");
	m_labelDir->setGeometry( 10, 50, 100, 20);
	m_labelDir->setText( i18n("Directory:") );

	m_labelFiles = new QLabel( this, "labelFiles" );
	m_labelFiles->setGeometry( 10, 90, 100, 20 );
	m_labelFiles->setText( i18n("Files filter:") );

	m_comboDir = new QComboBox( TRUE, this, "comboDir" );
	m_comboDir->setGeometry( 120, 40, 270, 30 );
	m_comboDir->setMaxCount( MAX_STRINGSINCOMBO );
	m_comboDir->setMinimumSize( 0, 0 );
	m_comboDir->setMaximumSize( 32767, 32767 );
	m_comboDir->setFocusPolicy( QWidget::StrongFocus );
	m_comboDir->setBackgroundMode( QWidget::PaletteBackground );
	m_comboDir->setFontPropagation( QWidget::AllChildren );
	m_comboDir->setPalettePropagation( QWidget::AllChildren );
	m_comboDir->setInsertionPolicy( QComboBox::AtBottom );
	m_comboDir->setSizeLimit( 10 );
	m_comboDir->setAutoResize( FALSE );
	m_comboDir->setAutoCompletion( FALSE );

	m_comboFilter = new QComboBox( TRUE, this, "comboFilter" );
	m_comboFilter->setGeometry( 120, 80, 270, 30 );
	m_comboFilter->setMaxCount( MAX_STRINGSINCOMBO );
	m_comboFilter->setMinimumSize( 0, 0 );
	m_comboFilter->setMaximumSize( 32767, 32767 );
	m_comboFilter->setFocusPolicy( QWidget::StrongFocus );
	m_comboFilter->setBackgroundMode( QWidget::PaletteBackground );
	m_comboFilter->setFontPropagation( QWidget::AllChildren );
	m_comboFilter->setPalettePropagation( QWidget::AllChildren );
	m_comboFilter->setInsertionPolicy( QComboBox::AtBottom );
	m_comboFilter->setSizeLimit( 10 );
	m_comboFilter->setAutoResize( FALSE );
	m_comboFilter->setAutoCompletion( FALSE );

	m_btnBrowse = new QPushButton( this, "btnBrowse" );
	m_btnBrowse->setGeometry( 400, 40, 80, 30 );
	m_btnBrowse->setMinimumSize( 0, 0 );
	m_btnBrowse->setMaximumSize( 32767, 32767 );
	m_btnBrowse->setFocusPolicy( QWidget::TabFocus );
	m_btnBrowse->setBackgroundMode( QWidget::PaletteBackground );
	m_btnBrowse->setFontPropagation( QWidget::NoChildren );
	m_btnBrowse->setPalettePropagation( QWidget::NoChildren );
	m_btnBrowse->setText( i18n("&Browse") );
	m_btnBrowse->setAutoRepeat( FALSE );
	m_btnBrowse->setAutoResize( FALSE );
	m_btnBrowse->setToggleButton( FALSE );
	m_btnBrowse->setDefault( FALSE );
	m_btnBrowse->setAutoDefault( FALSE );
	m_btnBrowse->setIsMenuButton( FALSE );
  connect(m_btnBrowse,SIGNAL(clicked()),this,SLOT(slotBrowse()));


	// *-*-*-*-*-*-*-*-*-*-* General Page Widgets -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	m_labelSearchfor = new QLabel( this, "labelSearchfor" );
	m_labelSearchfor->setGeometry( 10, 50, 100, 20);
	m_labelSearchfor->setText( i18n("Search for:") );

	m_labelReplaceby = new QLabel( this, "labelReplaceBy" );
	m_labelReplaceby->setGeometry( 10, 90, 100, 20 );
	m_labelReplaceby->setText( i18n("Replace by:") );

	m_comboSearch = new QComboBox( TRUE, this, "comboSearch" );
	m_comboSearch->setGeometry( 120, 40, 270, 30 );
	m_comboSearch->setMaxCount( MAX_STRINGSINCOMBO );
	m_comboSearch->setMinimumSize( 0, 0 );
	m_comboSearch->setMaximumSize( 32767, 32767 );
	m_comboSearch->setFocusPolicy( QWidget::StrongFocus );
	m_comboSearch->setBackgroundMode( QWidget::PaletteBackground );
	m_comboSearch->setFontPropagation( QWidget::AllChildren );
	m_comboSearch->setPalettePropagation( QWidget::AllChildren );
	m_comboSearch->setInsertionPolicy( QComboBox::AtBottom );
	m_comboSearch->setSizeLimit( 10 );
	m_comboSearch->setAutoResize( FALSE );
	m_comboSearch->setAutoCompletion( FALSE );

	m_comboReplace = new QComboBox( TRUE, this, "comboReplace" );
	m_comboReplace->setGeometry( 120, 80, 270, 30 );
	m_comboReplace->setMaxCount( MAX_STRINGSINCOMBO );
	m_comboReplace->setMinimumSize( 0, 0 );
	m_comboReplace->setMaximumSize( 32767, 32767 );
	m_comboReplace->setFocusPolicy( QWidget::StrongFocus );
	m_comboReplace->setBackgroundMode( QWidget::PaletteBackground );
	m_comboReplace->setFontPropagation( QWidget::AllChildren );
	m_comboReplace->setPalettePropagation( QWidget::AllChildren );
	m_comboReplace->setInsertionPolicy( QComboBox::AtBottom );
	m_comboReplace->setSizeLimit( 10 );
	m_comboReplace->setAutoResize( FALSE );
	m_comboReplace->setAutoCompletion( FALSE );

	m_btnAdd = new QPushButton( this, "btnAdd" );
	m_btnAdd->setGeometry( 400, 40, 80, 70 );
	m_btnAdd->setText( i18n("&Add") );
  connect(m_btnAdd, SIGNAL(clicked()),this,SLOT(slotAdd()));

	m_btnRemove = new QPushButton( this, "btnRem" );
	m_btnRemove->setGeometry( 400, 130, 80, 30 );
	m_btnRemove->setText( i18n("&Remove") );
  connect(m_btnRemove,SIGNAL(clicked()),this,SLOT(slotRemove()));

	m_btnClear = new QPushButton( this, "btnClear" );
	m_btnClear->setGeometry( 400, 170, 80, 30 );
	m_btnClear->setText( i18n("&Clear") );
  connect(m_btnClear,SIGNAL(clicked()),this,SLOT(slotClear()));

	m_TextList = new QListView( this, "listview" );
	m_TextList->setGeometry(10, 130, 380, 130);
	m_TextList->setTreeStepSize( 20 );
	m_TextList->setMultiSelection( TRUE );
	m_TextList->setAllColumnsShowFocus( FALSE );
	m_TextList->setItemMargin( 1 );
	m_TextList->addColumn(i18n("Search for"), -1 );
	m_TextList->setColumnWidthMode( 0, QListView::Maximum );
	m_TextList->setColumnAlignment( 0, 1 );
	m_TextList->addColumn(i18n("Replace by"), -1 );
	m_TextList->setColumnWidthMode( 1, QListView::Maximum );
	m_TextList->setColumnAlignment( 1, 1 );
	m_TextList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_TextList->setLineWidth(2);

	// *-*-*-*-*-*-*-*-*-*-* Options Page Widgets -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	m_checkRecursive = new QCheckBox(this);
	m_checkRecursive->setGeometry(10, 50, 300, 20);
	m_checkRecursive->setText( i18n("Replace in recursive Folders") );

	m_checkCaseSensitive = new QCheckBox(this);
	m_checkCaseSensitive->setGeometry(10, 80, 300, 20);
	m_checkCaseSensitive->setText( i18n("Case Sensitive") );

	m_checkBakup = new QCheckBox(this);
	m_checkBakup->setGeometry(10, 110, 300, 20);
	m_checkBakup->setText( i18n("Create copy of old files") );

	// *-*-*-*-*-*-*-*-*-*-* Options Page Date & Size -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	// ----------------------------- SIZE -------------------------------------
	m_checkSizeMin = new QCheckBox(this);
	m_checkSizeMin->setGeometry(10, 50, 200, 20);
	m_checkSizeMin->setText( i18n("MINimum file size:") );
	connect(m_checkSizeMin,SIGNAL(clicked()),SLOT(slotSizeMinClicked()));

	m_checkSizeMax = new QCheckBox(this);
	m_checkSizeMax->setGeometry(10, 80, 200, 20);
	m_checkSizeMax->setText( i18n("MAXimum file size:") );
	connect(m_checkSizeMax,SIGNAL(clicked()),SLOT(slotSizeMaxClicked()));
	
	m_editSizeMin = new QLineEdit(this);
	m_editSizeMin->setGeometry(250, 50, 70, 20);
	m_editSizeMin -> setEnabled(false); // Check box is not checked

	m_editSizeMax = new QLineEdit(this);
	m_editSizeMax->setGeometry(250, 80, 70, 20);
	m_editSizeMax -> setEnabled(false); // Check box is not checked

	m_labelKbMin = new QLabel(i18n("KB"), this, "");
	m_labelKbMin->setGeometry( 330, 50, 50, 20);

	m_labelKbMax = new QLabel(i18n("KB"), this, "");
	m_labelKbMax->setGeometry( 330, 80, 50, 20);


	// ----------------------------- DATE -------------------------------------

	m_checkDateOption = new QCheckBox(this);
	m_checkDateOption->setGeometry(10, 140, 100, 20);
	m_checkDateOption->setText( i18n("Last") );
	connect(m_checkDateOption,SIGNAL(clicked()),SLOT(slotDateOptionClicked()));

	m_labelDate = new QLabel(i18n("date access must be:"), this, "");
	m_labelDate->setGeometry(220, 140, 250, 20);

	m_comboDateRW = new QComboBox(FALSE, this, "");
	m_comboDateRW->setGeometry(110, 140, 100, 20 );
	m_comboDateRW -> insertItem(i18n("Write"));
	m_comboDateRW -> insertItem(i18n("Read"));
	m_comboDateRW -> setEnabled(false);
	
	m_checkDateMin = new QCheckBox(this);
	m_checkDateMin->setGeometry(35, 180, 100, 20);
	m_checkDateMin->setText( i18n("After") );
	m_checkDateMin -> setEnabled(false);
	connect(m_checkDateMin,SIGNAL(clicked()),SLOT(slotDateMinClicked()));

	m_checkDateMax = new QCheckBox(this);
	m_checkDateMax->setGeometry(35, 210, 100, 20);
	m_checkDateMax->setText( i18n("Before") );
	m_checkDateMax -> setEnabled(false);
	connect(m_checkDateMax,SIGNAL(clicked()),SLOT(slotDateMaxClicked()));

	m_editDateMin = new QLineEdit(this);
	m_editDateMin->setGeometry(140, 180, 90, 20);
	m_editDateMin -> setText("01/01/1980");
	m_editDateMin -> setEnabled(false);

	QString strToday;
	QDate date = QDate::currentDate();
	strToday.sprintf("%.2d/%.2d/%4d",date.day(),date.month(),date.year());
	m_editDateMax = new QLineEdit(this);
	m_editDateMax->setGeometry(140, 210, 90, 20);
	m_editDateMax -> setText(strToday.data());
	m_editDateMax -> setEnabled(false);
}

// ===========================================================================================================================
void KFileReplaceView::ResizeWidgets(QResizeEvent * event) // Resize all items	
{ // Resize the view
	resize(event -> size());
	
	// Resize TAB control
	m_tabctl->setGeometry(0, 0, event -> size().width(), 280);

	// Resize Lists
	m_TextList->setGeometry(10, 130, event -> size().width()-110, 130);
	m_List->setGeometry(10, 290, event -> size().width()-20, event -> size().height()-360);

  // Resize Combo Boxes
	m_comboDir->setGeometry(120, 40, event -> size().width()-220, 30);
	m_comboFilter->setGeometry(120, 80, event -> size().width()-220, 30);
	m_comboSearch->setGeometry(120, 40, event -> size().width()-220, 30);
	m_comboReplace->setGeometry(120, 80, event -> size().width()-220, 30);

	// Move buttons
	m_btnBrowse->move(event -> size().width()-90, 40);
	m_btnAdd->move(event -> size().width()-90, 40);
	m_btnRemove->move(event -> size().width()-90, 130);
	m_btnClear->move(event -> size().width()-90, 170);
	
}

// ===========================================================================================================================
KFileReplaceView::~KFileReplaceView()
{	
}

// ===========================================================================================================================
void KFileReplaceView::slotSizeMinClicked()
{ m_editSizeMin -> setEnabled(m_checkSizeMin -> isChecked() == TRUE && g_bThreadRunning == FALSE);
}

// ===========================================================================================================================
void KFileReplaceView::slotSizeMaxClicked()
{ m_editSizeMax -> setEnabled(m_checkSizeMax -> isChecked() == TRUE && g_bThreadRunning == FALSE);
}

// ===========================================================================================================================
void KFileReplaceView::slotDateOptionClicked()
{ m_comboDateRW -> setEnabled(m_checkDateOption -> isChecked() == TRUE && g_bThreadRunning == FALSE);
	m_checkDateMin -> setEnabled(m_checkDateOption -> isChecked() == TRUE && g_bThreadRunning == FALSE);
	m_checkDateMax -> setEnabled(m_checkDateOption -> isChecked() == TRUE && g_bThreadRunning == FALSE);
	m_editDateMin -> setEnabled((m_checkDateOption -> isChecked() == TRUE) && (m_checkDateMin -> isChecked() == TRUE) && g_bThreadRunning == FALSE);
	m_editDateMax -> setEnabled((m_checkDateOption -> isChecked() == TRUE) && (m_checkDateMax -> isChecked() == TRUE) && g_bThreadRunning == FALSE);
}

// ===========================================================================================================================
void KFileReplaceView::slotDateMinClicked()
{	bool bEnabled = (m_checkDateMin -> isChecked() == TRUE) && (m_checkDateOption -> isChecked() == TRUE) && (g_bThreadRunning == FALSE);
	m_editDateMin -> setEnabled(bEnabled);
}

// ===========================================================================================================================
void KFileReplaceView::slotDateMaxClicked()
{	bool bEnabled = (m_checkDateMax -> isChecked() == TRUE) && (m_checkDateOption -> isChecked() == TRUE) && (g_bThreadRunning == FALSE);
	m_editDateMax -> setEnabled(bEnabled);
}

// ===========================================================================================================================
void KFileReplaceView::GetMaxFilesSize(bool *bChecked, uint *nMaxSize)
{	*bChecked = m_checkSizeMax -> isChecked();

	if (*bChecked) // If option activated
  	*nMaxSize = atoi(m_editSizeMax -> text()) * 1024; // KB --> Bytes
	else
		*nMaxSize = 0;
}

// ===========================================================================================================================
void KFileReplaceView::GetMinFilesSize(bool *bChecked, uint *nMinSize)
{	*bChecked = m_checkSizeMin -> isChecked();

	if (*bChecked) // If option activated
  	*nMinSize = atoi(m_editSizeMin -> text()) * 1024; // KB --> Bytes
	else
		*nMinSize = 0;
}

// ===========================================================================================================================
void KFileReplaceView::slotTabSelection(int nPagenumber)
{
	// Hide all widgets

	// TAB_FILES
 	m_labelDir -> hide();
  m_labelFiles -> hide();
  m_btnBrowse -> hide();
 	m_comboDir-> hide();
	m_comboFilter-> hide();

	// TAB_TEXT
  m_labelSearchfor -> hide();
  m_labelReplaceby -> hide();
	m_btnAdd -> hide();
	m_btnRemove -> hide();
	m_btnClear -> hide();
	m_comboSearch -> hide();
	m_comboReplace -> hide();
	m_TextList -> hide();

	// TAB_OPTIONS
	m_checkRecursive -> hide();
	m_checkCaseSensitive -> hide();
	m_checkBakup -> hide();

	// TAB_DATESIZE
	m_checkSizeMin -> hide();
	m_checkSizeMax -> hide();
	m_editSizeMin -> hide();
	m_editSizeMax -> hide();
	m_labelKbMin -> hide();
	m_labelKbMax -> hide();
	m_checkDateOption -> hide();
	m_checkDateMax -> hide();
	m_checkDateMin -> hide();
	m_comboDateRW -> hide();
	m_editDateMax -> hide();
	m_editDateMin -> hide();
	m_labelDate -> hide();
			

	// Show used widgets
	switch(nPagenumber)
	{
		case TAB_FILES:
    	m_labelDir -> show();
    	m_labelFiles -> show();
  		m_btnBrowse -> show();
 			m_comboDir-> show();
			m_comboFilter-> show();
      break;

		case TAB_TEXT:
    	m_labelSearchfor -> show();
    	m_labelReplaceby -> show();
			m_btnAdd -> show();
			m_btnRemove -> show();
			m_btnClear -> show();
			m_comboSearch-> show();
			m_comboReplace-> show();
			m_TextList -> show();
      break;

		case TAB_OPTIONS:
			m_checkRecursive -> show();
			m_checkCaseSensitive -> show();
			m_checkBakup -> show();
			break;

		case TAB_DATESIZE:
			m_checkSizeMin -> show();
			m_checkSizeMax -> show();			
			m_editSizeMin -> show();
			m_editSizeMax -> show();
			m_labelKbMin -> show();
			m_labelKbMax -> show();
			m_checkDateOption -> show();
			m_checkDateMax -> show();
			m_checkDateMin -> show();
			m_comboDateRW -> show();
			m_editDateMax -> show();
			m_editDateMin -> show();
			m_labelDate -> show();
			break;


	};
}

// ===========================================================================================================================
void KFileReplaceView::slotBrowse()
{	QFileDialog dlg;	
  QString strDir;

	strDir = dlg.getExistingDirectory();
	if (strDir.isEmpty())
		return ;

	m_comboDir -> setEditText( (const char *) strDir);
}


// ===========================================================================================================================
void KFileReplaceView::slotClear()
{	
	m_TextList -> clear();
}

// ===========================================================================================================================
void KFileReplaceView::slotAdd()
{	
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	char szMess[MAX_MESSAGE];
	QString strSearch, strReplace;
	QListViewItem *lvi;
	bool bAlready;
	int i;

	strSearch.sprintf("%s", m_comboSearch -> currentText());
	strReplace.sprintf("%s", m_comboReplace -> currentText());

	if (strSearch.isEmpty()) // If combo boxes are empty
	{	KMsgBox::message(this, "KFileReplace", i18n("You must fill text you want to search for and text you want to replace by before adding it to list."), KMsgBox::EXCLAMATION, i18n("Cancel"));	
   		 return ;
	}

	// Insert items to Combo boxes
	QComboBox* combo[2] = {m_comboSearch, m_comboReplace};
	const char *szString[2] = {strSearch.data(), strReplace.data()};

	for (i=0; i < 2; i++)
	{	
		// Check string is not already in the combo
		bAlready = false;
		for (int j=0; j < combo[i] -> count(); j++)
		{	if ( strcmp(szString[i], combo[i] -> text(j)) == 0 )
				bAlready = true;
		}

		if (!bAlready) // Add it
		{	if (combo[i] -> count() >= MAX_STRINGSINCOMBO) // If full
				combo[i] -> removeItem(4);
		
			combo[i] -> insertItem(szString[i], 0);
		}
	}

	// Check item is not already in the TextList
	lviCurItem = lviFirst = m_TextList -> firstChild();
	if (lviCurItem != NULL)
	{	do // For all strings there are in the TextList
		{	if (strcmp(m_comboSearch -> currentText(), lviCurItem -> text(0)) == 0) // Item is already in the TextList
			{	sprintf(szMess, i18n("The \"%s\" item is already present in the list."), m_comboSearch -> currentText());
				KMsgBox::message(this, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
    				return ;
			}

			lviCurItem = lviCurItem -> nextSibling();
			} while(lviCurItem && lviCurItem != lviFirst);
	}

	// Check there is not too items to replace
	 if (m_TextList -> childCount() >= MAX_STRINGSTOSEARCHREP)
	{	sprintf(szMess, i18n("Unable to have more than %ld items to replace."), MAX_STRINGSTOSEARCHREP );
		KMsgBox::message(this, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
		return ;
	}

	// Add item to TextList
	lvi = new QListViewItem(m_TextList);

	lvi -> setText(0, strSearch.data());
	lvi -> setText(1, strReplace.data());
}

// ===========================================================================================================================
void KFileReplaceView::slotRemove()
{
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	QListViewItem *lviNext;
	
	lviCurItem = lviFirst = m_TextList -> firstChild();
	if (lviCurItem == NULL)
	{	return ;
	}

	do
	{	lviNext = lviCurItem -> nextSibling();

		if ( lviCurItem -> isSelected() )
		{	// Delete item from List
			delete lviCurItem; //m_TextList -> removeItem(lviCurItem);
		}

		lviCurItem = lviNext;

	} while(lviCurItem && lviCurItem != lviFirst);

	return ; // Error: item not in the list
}

// ===========================================================================================================================
void KFileReplaceView::EnableWidgets(bool bState)
{
	m_btnBrowse -> setEnabled(bState);
 	m_comboDir-> setEnabled(bState);
	m_comboFilter-> setEnabled(bState);

	// TAB_TEXT
	m_btnAdd -> setEnabled(bState);
	m_btnRemove -> setEnabled(bState);
	m_btnClear -> setEnabled(bState);
	m_comboSearch -> setEnabled(bState);
	m_comboReplace -> setEnabled(bState);

	// TAB_OPTIONS
	m_checkRecursive -> setEnabled(bState);
	m_checkCaseSensitive -> setEnabled(bState);
	m_checkBakup -> setEnabled(bState);

	// TAB_DATESIZE
	m_checkSizeMin -> setEnabled(bState);
	m_checkSizeMax -> setEnabled(bState);
	m_checkDateOption -> setEnabled(bState);
  slotDateMaxClicked();
	slotDateMinClicked();
	slotDateOptionClicked();
	slotSizeMaxClicked();
	slotSizeMinClicked();
}



