/***************************************************************************
                          filterdoc.h  -  description
                             -------------------
    begin                : Sun Mar 19 11:30:14 MET 2000
    copyright            : (C) 2000 by Martin Erdtmann
    email                : martin.erdtmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERDOC_H
#define FILTERDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qfile.h>
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include "driver.h"

// forward declaration of the Filter classes
class FilterView;

/**	FilterDoc provides a document object for a document-view model.
  *
  * The FilterDoc class provides a document object that can be used in conjunction with the classes FilterApp and FilterView
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the FilterApp instance and contains the document structure with the according methods for manipulation of the document
  * data by FilterView objects. Also, FilterDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class FilterDoc : public QObject
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    FilterDoc( QWidget *a_pqwidgetParent, const char* a_pcharName = 0 );

    /** Destructor for the fileclass of the application */
    ~FilterDoc();

/////////////////////////////////////////////////////////////////////
    bool Sound( int a_intIndex );
	bool Impedance( int a_intIndex );
	bool PressureSummary();
	bool ImpedanceSummary();
	bool PressureScalarSummary();
	double DB( double a_doubleA );

	void initParamDialog();
	void initNetworkDialog();
	void initVolumeDialog();
	void initToolsWizard();

	
	double  m_doubleXContainer[ 4 ][ 200 ];
	driver m_driverDriver[ 4 ];
	
/////////////////////////////////////////////////////////////////////

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView( FilterView* a_pfilterviewView );

    /** removes a view from the list of currently connected views */
    void removeView( FilterView* a_pfilterviewView );

    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool a_boolModified = true )
    {
    	m_boolModified = a_boolModified;
    };

    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified()
    {
    	return m_boolModified;
    };

    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	

    /** deletes the document's contents */
    void deleteContents();

    /** initializes the document generally */
    bool newDocument();

    /** closes the acutal document */
    void closeDocument();

    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument( const QString& a_qstringFilename, const char* a_pcharFormat = 0 );

    /** saves the document under filename and format.*/	
    bool saveDocument( const QString& a_qstringFilename, const char* a_pcharFormat = 0 );

    /** sets the path to the file connected with the document */
    void setAbsFilePath( const QString& a_qstringFilename );

    /** returns the pathname of the current document file*/
    const QString &getAbsFilePath() const;

    /** sets the filename of the document */
    void setTitle( const QString& a_qstringTitle );

    /** returns the title of the document */
    const QString &getTitle() const;
	
public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews( FilterView* a_pfilterviewSender );
	
	void viewrefresh();

public:	
    /** the list of the views currently connected to the document */
    static QList<FilterView> *m_pqlistViewList;

private:
    /** the modified flag of the current document */
    bool m_boolModified;
    QString m_qstringTitle;
    QString m_qstringAbsoluteFilePath;
	void truncatedFile( QFile* a_pqfileFile );
	
signals:
	void forceviewrefresh();

private slots: // Private slots
  /** is called when open dialogs
	need an update */
	void slotUpdateAllDialogs();

  /**  */
	void slot_EnableParamMenue();

  /**  */
	void slot_EnableNetworkMenue();

	void slot_EnableVolumeMenue();

signals: // Signals
  /** is sent when an open dialog
	needs update */
	void refreshDialog();
};

#endif // FILTERDOC_H
