/***************************************************************************
                          kbswitchapp.cpp  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbswitchapp.h"
#include "kbconfigdlg.h"

#include <qtooltip.h>
#include <kstddirs.h>
#include <kdebug.h>

KBSwitchApp::KBSwitchApp(){
  kbconf = new KBConfig();
  kbconf->load(config());
  QObject::connect(kbconf, SIGNAL(changed()), this, SLOT(slotKBConfChanged()));

  force_group_selection = false;
  int start_group = 0; // FIXME: hardcoded; need configuration

  trayicon = new KBSwitchTrayIcon(kbconf);
  QObject::connect(trayicon, SIGNAL(groupSelected(int)), this,
    SLOT(slotGroupSelected(int)));
  QObject::connect(trayicon, SIGNAL(clicked()), this, SLOT(slotSelectNextGroup()));
  QObject::connect(trayicon, SIGNAL(preferencesSelected()), this,
    SLOT(slotPreferences()));

  if (start_group != xkb.getGroupNo()) {
    if (kbconf->toggle_mode()) {
      toggle_groupno_new = start_group;
      toggle_groupno_old = getNextGroup(start_group);
    }
    else {
      toggle_groupno_old = start_group;
      toggle_groupno_new = start_group;
    }
    xkb.setKbdGroup(toggle_groupno_new);
  }
  else {
    toggle_groupno_old = start_group;
    toggle_groupno_new = getNextGroup(start_group);
    updateIcon(toggle_groupno_old);
  }
  //toggle_groupno_new = getGroupNo();

  setMainWidget(trayicon);
  trayicon->show();
}

KBSwitchApp::~KBSwitchApp(){
  delete kbconf;
}

/** No descriptions */
bool KBSwitchApp::x11EventFilter(XEvent *e){
  int groupno;
  if (xkb.isXkbStateNotifyEvent(e, &groupno)) {
    /*cout << "old group = " << toggle_groupno_old <<
       ", new group = " << toggle_groupno_new <<
       ", groupno = " << groupno <<
       ", force = " << int(force_group_selection) << endl;*/
    if (kbconf->toggle_mode() && !force_group_selection && groupno != toggle_groupno_new) {
      forceSelectGroup(toggle_groupno_new);
    }
    else {
      updateIcon(groupno);
      force_group_selection = false;
      if (kbconf->toggle_mode()) internalToggleGroups();
      else toggle_groupno_old = groupno;
    }
  }
  return KApplication::x11EventFilter(e);
}

/** Update the tray icon to show the flag corresponding to the current keyboard group */
void KBSwitchApp::updateIcon(int groupno){
//  int groupno = getGroupNo();
  if (groupno >= 0 && groupno < kbconf->groupCount()) { // check just in case
    QPixmap& pix = kbconf->getGroup(groupno)->getPixmap();
    trayicon->setPixmap(pix);
    trayicon->setActiveGroup(groupno);
    if (kbconf->toggle_mode()) trayicon->setToggleGroups(toggle_groupno_old, toggle_groupno_new);
    QToolTip::remove(trayicon);
    QToolTip::add(trayicon, kbconf->getGroup(groupno)->getName());
  }
}

/** No descriptions */
void KBSwitchApp::slotGroupSelected(int groupno) {
  int cur_groupno = xkb.getGroupNo();
  if (cur_groupno != groupno) {
    toggle_groupno_old = cur_groupno;
    toggle_groupno_new = groupno;
    forceSelectGroup(groupno);
  }
}

/** No descriptions */
void KBSwitchApp::internalToggleGroups(){
  int tmp = toggle_groupno_new;
  toggle_groupno_new = toggle_groupno_old;
  toggle_groupno_old = tmp;
}

/** No descriptions */
void KBSwitchApp::forceSelectGroup(int groupno){
  force_group_selection = true;
  xkb.setKbdGroup(groupno);
}

/** No descriptions */
void KBSwitchApp::slotSelectNextGroup(){
  if (kbconf->toggle_mode()) forceSelectGroup(toggle_groupno_new);
  else {
    int groupno = getNextGroup(toggle_groupno_old);
    forceSelectGroup(groupno);
  }
}

/** No descriptions */
void KBSwitchApp::slotPreferences(){
//  kdDebug() << "preferences" << endl;
  KBConfigDlg dlg(kbconf);
  dlg.exec();
}

/** No descriptions */
void KBSwitchApp::slotKBConfChanged(){
  updateIcon(xkb.getGroupNo());
}
