/***************************************************************************
                          groupmanager.cpp  -  description
                             -------------------
    begin                : Wed Nov 8 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "groupmanager.h"

#include <qdir.h>
#include <qstringlist.h>
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include "info.h"
#include "udgdialog.h"
#include <iostream.h>

GroupManager::GroupManager(){
	udgList = new QList<UDG>;
	udgList -> setAutoDelete(true);
  rpmList = new QList<RPM>;
	rpmList -> setAutoDelete(true);
  insList = new QList<INS>;
	insList -> setAutoDelete(true);
	initUDG = false;
	initRPM = false;
	initINS = false;
//	init();
}

GroupManager::~GroupManager(){
	delete udgList;
	delete rpmList;
	delete insList;
}

unsigned int GroupManager::count(grouptype type){
	unsigned int r = 0;
	if (type == TYPE_UDG)
		r = udgList -> count();
	if (type == TYPE_RPM)
		r = rpmList -> count();
	if (type == TYPE_INS)
		r = insList -> count();
	return r;
}

void GroupManager::init(grouptype tp){
	if (tp == TYPE_UDG){
		initUDG = true;
		bool b = false;
		QDir d(udgDir());
		QStringList * l = new QStringList(d.entryList());
		for (unsigned int i = 0; i < l -> count(); i++){
			QFileInfo f(udgDir() + QString(*l -> at(i)));
			QString s(f.fileName());
			if (s.right(7) == ".config"){
				b = true;
				UDG * u = new UDG(f.baseName());
				u -> load();
				add(u);
			}
		}
		delete l;
		if (!b){
			if (KMessageBox::questionYesNo(0
			,i18n("No file groups have been found.\nShould I install the default groups?")
			,i18n("Install Default Groups")) == KMessageBox::Yes)
				setupDefaultUDG();
		}
  }

	if (tp == TYPE_RPM){
		initRPM= true;
		setRPMSafetyLevel(28);
	}

	if (tp == TYPE_INS){
		initINS = true;
		bool b = false;
		QDir d(insDir());
		QStringList * l2 = new QStringList(d.entryList());
		for (unsigned int j = 0; j < l2 -> count(); j++){
			QFileInfo f(insDir() + QString(*l2 -> at(j)));
			QString s(f.fileName());
			if (s.right(6) == ".files"){
				b = true;
				INS * in = new INS(s.left(s.length() - 6)); //use of baseName() is not possible because of possible dots in file name
				in -> loadFiles();
				if (in -> numFiles() == 0){
					QString c("rm -vf ");
					c += insDir() + in -> baseFileName() + ".files";
					system(c);
					delete in;
				}
				else
					add(in);
			}
		}
		delete l2;
	}
}
	

UDG * GroupManager::udg(QString s){
	UDG * u;
	for (unsigned int i = 0; i < count(TYPE_UDG); i++){
		if (udg(i) -> name() == s){
			u = udg(i);
			break;
		}
	}
	return u;
}

RPM * GroupManager::rpm(QString s){
	RPM * r;
	for (unsigned int i = 0; i < count(TYPE_RPM); i++){
		if (rpm(i) -> name() == s){
			r = rpm(i);
			break;
		}
	}
	return r;
}

INS * GroupManager::ins(QString s){
	INS * r;
	for (unsigned int i = 0; i < count(TYPE_INS); i++){
		if (ins(i) -> name() == s){
			r = ins(i);
			break;
		}
	}
	return r;
}

void GroupManager::save(){
	for (unsigned int i = 0; i < count(TYPE_UDG); i++)
		this -> udg(i) -> save();
}
	
void GroupManager::remove(grouptype t, unsigned int i){
	if (t == TYPE_UDG)
		udgList -> remove(udg(i));
	if (t == TYPE_RPM)
		rpmList -> remove(rpm(i));
	if (t == TYPE_INS)
		insList -> remove(ins(i));
}

void GroupManager::remove(grouptype t, QString n){
	if (t == TYPE_UDG)
		udgList -> remove(udg(n));
	if (t == TYPE_RPM)
		rpmList -> remove(rpm(n));
	if (t == TYPE_INS)
		insList -> remove(ins(n));
}

void GroupManager::setupDefaultUDG(){
		UDG * u = new UDG("");
		u -> setName(i18n("Trash Files"));
		u -> setDescription(i18n("These files have been put in the trash by the user."));
		u -> setDir("~/Desktop/Trash");
		u -> addPattern("*");
		u -> setIcon("trash.png");
		u -> setSafetyLevel(7);
		u -> save();
		udgList -> append(u);
		
		u = new UDG("");
		u -> setName(i18n("Backup Files"));
		u -> setDescription(i18n("The files in this group are usually left by text editors after saving an already existing file."));
		u -> addPattern("*~");
		u -> setIcon("recycled.png");
		u -> setSafetyLevel(7);
		u -> save();
		udgList -> append(u);

		u = new UDG("");
		u -> setName(i18n("Object Files"));
		u -> setDescription(i18n("Object files are created during compile time of a program. After linking these files into an executable they are not needed anymore unless you are a developer."));
		u -> addPattern("*.o");
		u -> setIcon("source_o.png");
		u -> setSafetyLevel(2);
		u -> save();
		udgList -> append(u);
  		
		u = new UDG("");		
		u -> setName(i18n("Core Files"));
		u -> setDescription(i18n("Core files may appear when a program has crashed.It contains debugging information. When you are not a developer you don't need these files."));
		u -> addPattern("core");
		u -> setIcon("core.png");
		u -> setSafetyLevel(0);
		u -> save();
		udgList -> append(u);
		
		u = new UDG("");		
		u -> setName(i18n("Hidden Files"));
		u -> setDescription(i18n("Hidden files are usually left by programs to store configuration information. When a hidden file hasn't been accessed for a long time it probably means the corresponding program doesn't exist any more."));
		u -> addPattern(".*");
		u -> setIcon("mime_empty.png");
		u -> setSafetyLevel(28);
		u -> save();
		udgList -> append(u);
		
		u = new UDG("");		
		u -> setName(i18n("Temporary Files"));
		u -> setDescription(i18n("These files are mostly created by programs to store information."));
		u -> setDir("/tmp");
		u -> addPattern("*");
		u -> setIcon("mime_empty.png");
		u -> setSafetyLevel(2);
		u -> save();
		udgList -> append(u);

		u = new UDG("");		
		u -> setName(i18n("Messages log file"));
		u -> setDescription(i18n("You need root acces to empty this file"));
		u -> permanent -> append("/var/log/messages");
		u -> addPermanentFiles();
		u -> setCommand("killall -HUP syslogd");
		u -> setIcon("mime_empty.png");
		u -> setSafetyLevel(0);
		u -> schedule() -> setDayCycle(7);
		u -> schedule() -> addHour(20);
		u -> schedule() -> addMinute(0);
		u -> setAction(DELETE_BACKUP);
		u -> save();
		udgList -> append(u);

		u = new UDG("");		
		u -> setName(i18n("Netscape Cache"));
		u -> setDescription(i18n("Cache files created by Netscape"));
		u -> setIcon("netscape.png");
		u -> setDir("~/.netscape");
		u -> addPattern("cache*");
		u -> setSafetyLevel(7);
		u -> save();
		udgList -> append(u);

		u = new UDG("");		
		u -> setName(i18n("Netscape Mail Trash"));
		u -> setDescription(i18n(""));
		u -> setIcon("netscape.png");
		u -> permanent -> append("~/nsmail/Trash");
		u -> addPermanentFiles();
		u -> setSafetyLevel(0);
		u -> save();
		udgList -> append(u);
}

void GroupManager::startScheduling(){
	for (unsigned int i = 0; i < count(TYPE_UDG); i++)
		udg(i) -> schedule() -> start();
}

void GroupManager::stopScheduling(){
	for (unsigned int i = 0; i < count(TYPE_UDG); i++)
		udg(i) -> schedule() -> stop();
}

void GroupManager::update(grouptype type, QString dir){
	updateType = type;
	if (type==TYPE_UDG){
		updateProcess = new ABProcess("find");
		updateUDGProgress = new SearchProgress();
		connect(updateUDGProgress -> QPushButton_2, SIGNAL(clicked()), SLOT(slotCancel()));
		if (dir != QString("")){
			connect(updateProcess, SIGNAL(receivedStdout(KProcess *,char *, int))
				,SLOT(slotUpdateUDG(KProcess *,char *,int )));
				connect(updateProcess, SIGNAL(processExited(KProcess *)),SLOT(slotUpdateReady()));
			updateProcess -> clearArguments();
			*updateProcess << "find";
			*updateProcess << dir;
			updateProcess -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
		}
	}
	if (type==TYPE_RPM){
		rpmList -> clear();
		counter = 0;
		updateRPMProgress = new QueryProgress_2();
    updateRPMProgress -> QLabel_1 -> setText(i18n("Check system for RPM's..."));
		connect(updateRPMProgress -> QPushButton_1, SIGNAL(clicked()), SLOT(slotCancel()));
		updateRPMProgress -> show();
		updateProcess = new ABProcess("rpm");
		connect(updateProcess, SIGNAL(processExited(KProcess *)),SLOT(slotRPMQueryEnded()));
		*updateProcess << "rpm";
		*updateProcess << "-qa";
		updateProcess -> start(KProcess::NotifyOnExit, KProcess::AllOutput);
	}
}

void GroupManager::slotUpdateUDG(KProcess *, char * b, int l){
	QString f;
	QFileInfo fi;
  char * nb = new char[l+1];
  for (int i = 0; i <= l - 1; i++)
		nb[i] = b[i];
	nb[l] = '\0';
	std.append(nb);
	delete nb;
	uint i = 1;
	QString txt = "";
  while (i <= std.length()){
		if (std.mid(i,1) == "\n"){
	 		f = std.left(i);
	 		fi.setFile(f);
			if (fi.isFile() & (fi.ownerId()==getuid() | getuid() == 0)){
				txt = "Analyzing files...\n" + fi.dirPath();
				if (txt != updateUDGProgress -> QLabel_1 -> text())
					updateUDGProgress -> QLabel_1 -> setText(txt);
				for (uint j = 0; j < count(TYPE_UDG); j++)
					udg(j) -> tryFile(f);
			}
			std = std.right( std.length() - i - 1);
			i = 0;
		}
		i++;
  }
}

void GroupManager::showUpdateProgress(grouptype type, bool b){
	if (type == TYPE_UDG){
		if (b)
			updateUDGProgress -> show();
		else
			updateUDGProgress -> hide();
	}
}

void GroupManager::slotRPMQueryEnded(){
	updateRPMProgress -> QProgressBar_1 -> setProgress(0);
	updateRPMProgress -> QProgressBar_1 -> setTotalSteps(updateProcess -> output -> count());
	KIconLoader l;
	updateRPMProgress -> QLabel_2 -> setPixmap(l.loadIcon("rpm", KIcon::Small));

	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), SLOT(slotRPM()));
	timer -> start(0);
}

void GroupManager::slotRPM(){
	if (counter == updateProcess -> output -> count()){
		timer -> stop();
		slotUpdateReady();
	}
	else{
		updateRPMProgress -> QProgressBar_1 -> setProgress(counter);
	  updateRPMProgress -> QLabel_1 -> setText(updateProcess -> output -> at(counter));
//		updateRPMProgress ->repaint();
		_rpm = new RPM(updateProcess -> output -> at(counter),rpmSafetyLevel());
		add(_rpm);
//		_rpm -> load();
		_rpm -> clearMem();
		counter++;
	}
}

void GroupManager::slotCancel(){
	if (updateType == TYPE_UDG)
		slotUpdateReady();
	if (updateType == TYPE_RPM)
		counter = updateProcess -> output -> count();
}

void GroupManager::slotUpdateReady(){
	if (updateType == TYPE_UDG){
		for (unsigned int i = 0; i < count(TYPE_UDG); i++){
			udg(i) -> sync();
			cout << udg(i) -> numFiles() << "\n";
		}
		delete updateProcess;
		delete updateUDGProgress;
	}
	if (updateType == TYPE_RPM){
		delete updateProcess;
		delete updateRPMProgress;
	}
	emit updateReady();
}

void GroupManager::setRPMSafetyLevel(unsigned int s){
	rpmslvl = s;
	for (unsigned int i = 0; i < count(TYPE_RPM); i++)
		rpm(i) -> setSafetyLevel(s);
}

void GroupManager::clear(grouptype gt){
	if (gt == TYPE_UDG)
		udgList -> clear();
	if (gt == TYPE_RPM)
		rpmList -> clear();
	if (gt == TYPE_INS)
		insList -> clear();
}

bool GroupManager::isInit(grouptype tp){
	bool b = false;
	if (tp == TYPE_UDG)
		b = initUDG;
	if (tp == TYPE_RPM)
		b = initRPM;
	if (tp == TYPE_INS)
		b = initINS;
	return b;
}