/***************************************************************************
                          groupviewwindow.cpp  -  description
                             -------------------
    begin                : Wed Nov 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "groupviewwindow.h"
#include <kstdaction.h>
#include <kaction.h>

#include "configuredialog.h"

GroupViewWindow::GroupViewWindow(GroupManager * gm){
	groupManager = gm;
	groupViewWidget = new GroupViewWidget(gm,this);
	this -> setMinimumSize(600,500);
	new KAction (i18n("New UDG"), 0, groupViewWidget -> udgItem, SLOT(slotNewUDG()), actionCollection(),"new udg");
	new KAction (i18n("Update UDG"), 0, groupViewWidget, SLOT(slotUpdateUDG()), actionCollection(),"update");
	new KAction (i18n("Uninstall"), 0, this, SLOT(slotUninstall()), actionCollection(),"uninstall");
	new KAction (i18n("Configure Kleandisk"),0, this, SLOT(slotConfigure()), actionCollection(),"configure");
	KStdAction::close (this, SLOT(slotClose()), actionCollection());
	createGUI();
}

GroupViewWindow::~GroupViewWindow(){
	delete groupViewWidget;
}

void GroupViewWindow::resizeEvent(QResizeEvent * e){
	int m = 20;
	int w = e -> size().width();
	int h = e -> size().height();
	groupViewWidget -> setGeometry(0,m,w,h-m);
}

void GroupViewWindow::slotClose(){
	delete this;
}

void GroupViewWindow::slotUninstall(){
	uninstallDialog = new UninstallDialog(groupManager);
	int r = uninstallDialog -> exec();
	if (r == 0){
		for (unsigned int i = 0; i < uninstallDialog -> batch -> count(); i++){
			if (uninstallDialog -> batch -> process(i) -> error().isEmpty()){
				if (uninstallDialog -> batch -> group(i) -> type() == TYPE_RPM){
					groupViewWidget -> rpmItem -> deleteItem(uninstallDialog -> batch -> group(i) -> name());
					groupManager -> remove(TYPE_RPM, uninstallDialog -> batch -> group(i) -> name());
				}	
				if (uninstallDialog -> batch -> group(i) -> type() == TYPE_INS){
					groupManager -> remove(TYPE_INS, uninstallDialog -> batch -> group(i) -> name());
					groupViewWidget -> insItem -> setup();
				}
			}
		}
	}
	delete uninstallDialog;
}

void GroupViewWindow::slotConfigure(){
	ConfigureDialog * dialog = new ConfigureDialog();
	dialog -> exec();
}
