/***************************************************************************
                          kleandisk.cpp  -  description
                             -------------------
    begin                : wo feb  7 09:47:42 CET 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <kstdaction.h>
#include <klocale.h>
#include <kaction.h>
#include <kmessagebox.h>

#include "info.h"
#include "kleandisk.h"
#include "configuredialog.h"
#include "restorewizard.h"
#include "uninstalldialog.h"

Kleandisk::Kleandisk(){
	//check dirs
	
	system(QString("mkdir ") + udgDir());
	system(QString("mkdir ") + insDir());
	system(QString("mkdir ") + defaultArchiveDir());
	
  groupViewWidget = new GroupViewWidget(this);
	this -> setMinimumSize(600,500);
	new KAction (i18n("New UDG"), 0, groupViewWidget -> udgTree, SLOT(slotNewUDG()), actionCollection(),"new udg");
	new KAction (i18n("Update UDG"), 0, groupViewWidget -> udgTree, SLOT(slotUpdateGroups	()), actionCollection(),"update");
	new KAction (i18n("Uninstall selected Installed Files"), 0, this, SLOT(slotUninstallINS()), actionCollection(),"uninstallINS");
	new KAction (i18n("Uninstall selected RPM's"), 0, this, SLOT(slotUninstallRPM()), actionCollection(),"uninstallRPM");
	new KAction (i18n("Configure Kleandisk"),0, this, SLOT(slotConfigure()), actionCollection(),"configure");
	new KAction (i18n("Restore..."),0, this, SLOT(slotRestore()), actionCollection(),"restore");
	KStdAction::close (this, SLOT(slotClose()), actionCollection());
	createGUI();
}

void Kleandisk::resizeEvent(QResizeEvent * e){
	int m = 20;
	int w = e -> size().width();
	int h = e -> size().height();
	groupViewWidget -> setGeometry(0,m,w,h-m);
}

Kleandisk::~Kleandisk(){
}

void Kleandisk::slotUninstallINS(){
	groupViewWidget -> FileListView1 -> init();
	if (groupViewWidget -> insTree -> numMarked() == 0){
		KMessageBox::information(0,i18n("No groups selected"));
		return;
	}
	UninstallDialog d(groupViewWidget -> insTree);
	int r = d.exec();
}

void Kleandisk::slotUninstallRPM(){
	groupViewWidget -> FileListView1 -> init();
	if (groupViewWidget -> rpmTree -> numMarked() == 0){
		KMessageBox::information(0,i18n("No groups selected"));
		return;
	}
	UninstallDialog d(groupViewWidget -> rpmTree);
	int r = d.exec();
}

void Kleandisk::slotConfigure(){
	ConfigureDialog d;
	d.exec();
}

void Kleandisk::slotRestore(){
	RestoreWizard w;
	w.exec();
}

void Kleandisk::slotClose(){
	groupViewWidget -> udgTree -> saveGroups();
	delete this;
}

