/***************************************************************************
                          kcontainer.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontainerimpl.h"
#include "kcontainer.h"

KContainer::KContainer(KContainerImpl *impl) : KObject(impl) {
}

KContainerImpl * KContainer::impl() const {
  return dynamic_cast<KContainerImpl*>(KObject::impl());
}

KObject::List KContainer::globals() const {
  List lst;
  for (ObjDictIterator i(impl()->globals()); 
       i.current() != 0; ++i)
    lst += KObject(i.current());
  return lst;
}

bool KContainer::isEmpty() const { 
  return impl()->isEmpty(); 
}

void KContainer::clear() { 
  impl()->clear(); 
}

KObject KContainer::itemCopy(const QDomElement &e) const { 
  return KObject(impl()->itemCopy(e)); 
}

void KContainer::itemRemove(const KObject &item) { 
  impl()->itemRemove(item.impl()); 
}
 
KObject KContainer::itemFindId(int id) const {
  return KObject(impl()->itemFindId(id)); 
}

int KContainer::itemFind(const KObject &item) const { 
  return impl()->itemFind(item.impl()); 
}

KObject KContainer::itemAt(int index) const { 
  return KObject(impl()->itemAt(index)); 
}

KObject KContainer::itemFirst() const { 
  return KObject(impl()->itemFirst()); 
}

KObject KContainer::itemLast() const { 
  return KObject(impl()->itemLast()); 
}

KObject KContainer::itemNext() const { 
  return KObject(impl()->itemNext()); 
}

KObject KContainer::itemPrev() const { 
  return KObject(impl()->itemPrev()); 
}

int KContainer::itemCount() const { 
  return impl()->itemCount(); 
}

int KContainer::itemActiveCount() const { 
  return impl()->itemActiveCount(); 
}
