/***************************************************************************
                          kdlgmanager.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.4 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGMANAGER_H
#define KDLGMANAGER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <klocale.h>
#include <qtabdialog.h>
#include "ktmanager.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif


class KDlgManager1;
class KDlgManager2;
class KDlgTransfer1;
class KDlgTransferWget1;

/**
 * @short Dialog class for @ref KTManager configuration
 * @author Sergio Moretti
 * @version $Id$
 * This is a tabbed dialog created with pages for @ref KTManager
 * configuration, @ref KDlgManager1, plus all the pages of 
 * transfers classes contained in manager, @ref @KDlgTransfer1, 
 * @ref KDlgTransferWget1, ...
 */

class KDlgManager : public QTabDialog {
   Q_OBJECT
public:
   KDlgManager(KTManager mngr, QWidget *parent, const char *name=0);
   ~KDlgManager();
protected slots: // Protected slots
  /**  */
  void accept();
protected: // Protected methods
  /** init dialog state */
  void init();
private:
  KTManager m;
  KDlgManager1 *_p1;
  KDlgTransfer1 *_p2;
  KDlgTransferWget1 * _p3;
#ifdef ENABLE_KIO
  KDlgTransfer1 * _p4;
#endif
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
