/***************************************************************************
                          kdlgopentransfer.cpp  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtooltip.h>
#include <kfiledialog.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgroupbox.h>
//#include <kapp.h>
#include <kdebug.h>
#include "kmago.h"
#include "utils.h"
#include "ktmanager.h"
#include "kdlgopentransfer.h"


KDlgOpenTransfer * KDlgOpenTransfer::dlg = 0;


KDlgOpenTransfer::KDlgOpenTransfer(QWidget *parent, const char *name) : 
  // don't enable WDestructiveClose
  QDialog(parent,name,true) {
  initDialog();
}

KDlgOpenTransfer::~KDlgOpenTransfer() {
}

void KDlgOpenTransfer::initDialog() {

  setCaption(i18n("Open Transfer"));

  QBoxLayout *l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(1, Horizontal, this);
  l->addWidget(gbox);
  
  QLabel *lbl = new QLabel(i18n("URL to download:"), gbox,"LblURL");
  cmbURL = new KComboBox(true, gbox,"CmbURL");
  connect(cmbURL, SIGNAL(activated(const QString&)), 
	  this, SLOT(slotReadURL(const QString&)));

  lbl = new QLabel(i18n("Write to file:"), gbox,"LblFile");
  cmbFile = new KURLRequester(gbox, "CmbFile");
  KFile::Mode mode = static_cast<KFile::Mode>(KFile::File|KFile::LocalOnly);
  cmbFile->fileDialog()->setMode(mode);

  QHBox * box = new QHBox(gbox);
  lbl = new QLabel(i18n("Transfer Type"), box, "LblType");
  cmbType= new KComboBox(box, "CmbType");
  box->setStretchFactor(lbl, 5);
  box->setStretchFactor(cmbType, 1);

  QHBoxLayout *btnBox = new QHBoxLayout(l);
  btnBox->addStretch(1);

  QPushButton *btn = new QPushButton(i18n("OK"), this, "BtnOK");
  //btn->setDefault(true);
  btnBox->addWidget(btn);
  connect(btn, SIGNAL(clicked()), this, SLOT(accept()));

  btn = new QPushButton(i18n("Cancel"), this, "BtnCancel");
  btnBox->addWidget(btn);
  connect(btn, SIGNAL(clicked()), this, SLOT(reject()));
}

void KDlgOpenTransfer::init(KTManager m, const KURL &rmt, const KURL &lcl, 
			    int type, int flgs) {
  cmbType->clear();
  KObject::List lst = m.globals();
  _typeList.clear();
  for(KObject::List::Iterator i = lst.begin(); i != lst.end(); ++i) {
    cmbType->insertItem(KObject::typeStr((*i).type()));
    _typeList += (*i).type();
  }
  _type = type;
  _flags = flgs;
  _dir = m.getDownloadDir();
  if (!rmt.path().isEmpty()) {
    _rmt = rmt;
    cmbURL->setEditText(_rmt.url());
  }
  cmbFile->fileDialog()->setURL(_dir.absPath());
  if (!lcl.path().isEmpty()) {
    _lcl = lcl;
    cmbFile->setURL(_lcl.path());
  }
  cmbType->setCurrentItem(_typeList.findIndex(type));
}

bool KDlgOpenTransfer::getOpenTransfer(KTManager m, KURL &rmt, 
				       KURL &lcl, int &type, int flgs) {
  if (dlg == 0)
    dlg = new KDlgOpenTransfer(kapp->mainWidget(), "KDlgOpenTransfer");
  dlg->init(m, rmt, lcl, type, flgs);
  if (dlg->exec() == Accepted) {
    rmt = dlg->_rmt;
    lcl = dlg->_lcl;
    type = dlg->_type;
    kdDebug(D_VIE) << "getOpenTransfer: URL=" << rmt.url() << ",FILE=" << lcl.path() << ",TYPE=" << type << endl;
    return true;
  }
  return false;
}

/** open file dialog to select filename
void KDlgOpenTransfer::slotOpenFileDlg(){
	QString newfile = KFileDialog::getOpenFileName();
	if (newfile.isEmpty())
		return;
	lneFile->setText(newfile);
}
*/

/** close the dialog acceptiong the selection */
void KDlgOpenTransfer::accept(){
  if (cmbURL->currentText() == "" || cmbFile->url() == "")
    return;
  _rmt = cmbURL->currentText();
  _lcl.setPath(cmbFile->url());
  _type = _typeList[cmbType->currentItem()];
  //kdDebug(D_VIE) << name() << ": URL=<" << _rmt.url() << "> =>" << _rmt.isMalformed() << " FILE=<" << _lcl.path() << ">" << endl;
  if (_rmt.path().isEmpty() || _rmt.isMalformed() 
      || _lcl.path().isEmpty() 
      || !QDir::current().exists(_lcl.directory())
      || (_flags & FLG_FILE_FORCE_ENCODE 
	  && _lcl.path().find(' ') != -1)
      )
    return;
  QDialog::accept();
}

/** create the file name, based on the url */
void KDlgOpenTransfer::slotReadURL(const QString &u){
  _rmt = u;
  if (!_rmt.path().isEmpty()) {
    cmbURL->setEditText(_rmt.url());
    _lcl.setPath(correctFile(_rmt.fileName()));
    cmbFile->setURL(_lcl.path());
  }
}

/** try to correct the url
KURL KDlgOpenTransfer::correctURL(const QString &u) {
KURL url(u);
	if (url.url() == ":" || url.isMalformed()) {
		KURL url2(QString("http://") + u);
		if (url2.url() != ":" && !url2.isMalformed())
			url = url2;
		else
			return url;
	}
	if (_flags & FLG_URL_AUTO_ENCODE) {
		QString proto = url.protocol();
		QString str = url.url().mid(proto.length()+1, url.url().length());
		kdDebug() << "S1=" << str;
		if (str.find(' ') != -1) {
			str = KURL::encode_string(str);
			kdDebug() << "S2=" << str;
			url = proto + ":" + str;
		}
	}
	return url;
}
*/

/** correct file name */
QString KDlgOpenTransfer::correctFile(const QString &f) {
  QFileInfo file(_dir, f);
  if (_flags & FLG_FILE_AUTO_ENCODE) {
    QString filename = file.fileName();
    int p;
    while ((p = filename.find(' ')) != -1) {
      filename[p] = '_';
    }
    file.setFile(_dir, filename);
  }
  return file.absFilePath();
}

#include "kdlgopentransfer.moc"
