/***************************************************************************
                          kdlgtransferwget1.cpp  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qfileinfo.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgrid.h>
#include "kdlgtransferwget1.h"

KDlgTransferWget1::KDlgTransferWget1(KTransferWget tr, QWidget *parent, 
				     const char *name) : QWidget(parent,name){
  t = tr;
  initDialog();
  init();
}

KDlgTransferWget1::~KDlgTransferWget1(){
}

/** init dialog state */
void KDlgTransferWget1::init(){
  slotSetGlobal(t.isGlobal());
  cbtCache->setChecked(t.getHTTPCache());
  cbtPasv->setChecked(t.getPassiveFtp());
  cbtProxy->setChecked(t.getProxy());
  lneNoProxy->setText(t.getNoProxyList().join(","));
  lnePFA->setText(t.getProxyFTP());
  lnePFP->setText(QString().setNum(t.getProxyPortFTP()));
  lnePHA->setText(t.getProxyHTTP());
  lnePHP->setText(QString().setNum(t.getProxyPortHTTP()));
  lneReadTO->setText(QString().setNum(t.getReadTimeout()));
  lneCmdPath->setText(t.getCmdPath());
  cmbSpeed->setCurrentItem(t.getSpeed());
  connect(cbtProxy, SIGNAL(toggled(bool)), this, SLOT(slotSetProxy(bool)));
}

void  KDlgTransferWget1::initDialog(){

  QBoxLayout *l = new QVBoxLayout(this, 8);

  QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this, "GB1");
  l->addWidget(gbox);

  QHBox *box = new QHBox(gbox);
  QLabel *lbl = new QLabel(i18n("Command Path"), box, "lneCmdPath");
  lneCmdPath = new QLineEdit(box, "LneCmdPath");
  QToolTip::add(lneCmdPath,i18n("Path of wget executable"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneCmdPath, 0);

  box = new QHBox(gbox);  
  lbl = new QLabel(i18n("Read Timeout"), box);
  lneReadTO = new QLineEdit(box, "lneReadTO");
  lneReadTO->setFixedWidth(lneReadTO->fontMetrics().width("XXXXXX"));
  QToolTip::add(lneReadTO,i18n("Read Timeout in seconds"));
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(lneReadTO, 0);

  cbtPasv = new QCheckBox(i18n("Enable FTP passive mode"), gbox, "cbtPasv");

  cbtCache = new QCheckBox(i18n("Allow HTTP server-cached data"), gbox, 
			   "cbtCache");

  box = new QHBox(gbox);  
  lbl = new QLabel(i18n("Transfer Speed"), box);
  cmbSpeed = new KComboBox(box, "cmbSpeed");
  QToolTip::add(cmbSpeed,i18n("Transfer speed"));
  cmbSpeed->insertItem("Default");
  cmbSpeed->insertItem("Binary");
  cmbSpeed->insertItem("Mega");
  cmbSpeed->insertItem("Micro");
  box->setStretchFactor(lbl, 1);
  box->setStretchFactor(cmbSpeed, 0);

  gbox = new QGroupBox(1, Horizontal, i18n("Proxy"), this, "GB2");
  l->addWidget(gbox);

  cbtProxy = new QCheckBox(i18n("Enable Proxy"), gbox, "cbtProxy");

  QWidget *wbox = new QWidget(gbox);
  QGridLayout * lgrid = new QGridLayout(wbox, 2, 4, 4);

  lbl = new QLabel(i18n("HTTP Proxy:"), wbox);
  lgrid->addWidget(lbl, 0, 0);
  lnePHA = new QLineEdit(wbox, "lnePHA");
  QToolTip::add(lnePHA, i18n("HTTP proxy host name"));
  lgrid->addWidget(lnePHA, 0, 1);
  lbl = new QLabel(i18n("Port:"), wbox);
  lgrid->addWidget(lbl, 0, 2);
  lnePHP = new QLineEdit(wbox, "lnePHP");
  lnePHP->setFixedWidth(lnePHP->fontMetrics().width("XXXXX"));
  lgrid->addWidget(lnePHP, 0, 3);

  lbl = new QLabel(i18n("FTP Proxy:"), wbox);
  lgrid->addWidget(lbl, 1, 0);
  lnePFA = new QLineEdit(wbox, "lnePFA");
  QToolTip::add(lnePFA, i18n("Ftp proxy host name"));
  lgrid->addWidget(lnePFA, 1, 1);
  lbl = new QLabel(i18n("Port:"), wbox);
  lgrid->addWidget(lbl, 1, 2);
  lnePFP = new QLineEdit(wbox, "lnePFP");
  lnePFP->setFixedWidth(lnePFP->fontMetrics().width("XXXXX"));
  lgrid->addWidget(lnePFP, 1, 3);

  lgrid->setColStretch(0, 1);
  lgrid->setColStretch(1, 10);
  lgrid->setColStretch(2, 1);
  lgrid->setColStretch(3, 0);

  new QLabel(i18n("No Proxy for:"), gbox);
  lneNoProxy = new QLineEdit(gbox, "lneNoProxy");
  QToolTip::add(lneNoProxy, i18n("List of comma or space separated host names, glob expressions are accepted for grouping, like *.xxx.yyy, or xxx.*"));
  
/*
  int 
    sx = 10,
    sw = 16,
    ew = 8,
    dw = 25,
    iw = 23,
    dmw = 5,
    w = 0,
    mw = 0;

  QGroupBox_1= new QGroupBox(this,"NoName");
  w = sw;

  QLabel_1= new QLabel(QGroupBox_1,"NoName");
  QLabel_1->setGeometry(sx, w, 90, iw);
  QLabel_1->setMinimumSize(0,0);
  QLabel_1->setText(i18n("Command Path"));

  lneCmdPath= new QLineEdit(QGroupBox_1,"NoName");
  lneCmdPath->setGeometry(110, w, 160, iw);
  lneCmdPath->setMinimumSize(0,0);
  w += dw;
  
  QLabel_2= new QLabel(QGroupBox_1,"NoName");
  QLabel_2->setGeometry(sx, w, 200, iw);
  QLabel_2->setMinimumSize(0,0);
  QLabel_2->setText(i18n("Read Timeout"));

  lneReadTO= new QLineEdit(QGroupBox_1,"NoName");
  lneReadTO->setGeometry(220, w, 50, iw);
  lneReadTO->setMinimumSize(0,0);
  QToolTip::add(lneReadTO,i18n("Read Timeout in seconds"));
  w += dw;

  cbtPasv= new QCheckBox(QGroupBox_1,"NoName");
  cbtPasv->setGeometry(sx, w, 260, iw);
  cbtPasv->setMinimumSize(0,0);
  cbtPasv->setText(i18n("Enable FTP passive mode"));
  w += dw;

  cbtCache= new QCheckBox(QGroupBox_1,"NoName");
  cbtCache->setGeometry(sx, w, 260, iw);
  cbtCache->setMinimumSize(0,0);
  cbtCache->setText(i18n("Allow HTTP server-cached data"));
  w += dw;

  lblSpeed = new QLabel(QGroupBox_1,"NoName");
  lblSpeed->setGeometry(sx, w, 150, iw);
  lblSpeed->setMinimumSize(0,0);
  lblSpeed->setText(i18n("Transfer Speed"));

  cmbSpeed = new KComboBox(QGroupBox_1,"NoName");
  cmbSpeed->setGeometry(160, w, 110, iw);
  cmbSpeed->setMinimumSize(0,0);
  QToolTip::add(cmbSpeed,i18n("Transfer speed"));
  cmbSpeed->insertItem("Default");
  cmbSpeed->insertItem("Binary");
  cmbSpeed->insertItem("Mega");
  cmbSpeed->insertItem("Micro");
  w += iw + ew;

  mw = sw;
  QGroupBox_1->setGeometry(sx, mw, 280, w);
  QGroupBox_1->setMinimumSize(0,0);
  QGroupBox_1->setTitle(i18n("General"));
  mw += w + dmw;

  QGroupBox_2= new QGroupBox(this,"NoName");
  w = sw;

  cbtProxy= new QCheckBox(QGroupBox_2,"NoName");
  cbtProxy->setGeometry(sx, w, 100, iw);
  cbtProxy->setMinimumSize(0,0);
  cbtProxy->setText(i18n("Enable Proxy"));
  w += dw;

  lblPHA= new QLabel(QGroupBox_2,"NoName");
  lblPHA->setGeometry(sx, w, 80, iw);
  lblPHA->setMinimumSize(0,0);
  lblPHA->setText(i18n("HTTP Proxy:"));

  lnePHA= new QLineEdit(QGroupBox_2,"NoName");
  lnePHA->setGeometry(90, w, 90, iw);
  lnePHA->setMinimumSize(0,0);
  QToolTip::add(lnePHA, i18n("HTTP proxy host name"));
  
  QLabel_4= new QLabel(QGroupBox_2,"NoName");
  QLabel_4->setGeometry(190, w, 40, iw);
  QLabel_4->setMinimumSize(0,0);
  QLabel_4->setText(i18n("Port:"));
  
  lnePHP= new QLineEdit(QGroupBox_2,"NoName");
  lnePHP->setGeometry(230, w, 40, iw);
  lnePHP->setMinimumSize(0,0);
  w += dw;

  lblPFA= new QLabel(QGroupBox_2,"NoName");
  lblPFA->setGeometry(sx, w, 80, iw);
  lblPFA->setMinimumSize(0,0);
  lblPFA->setText(i18n("FTP Proxy:"));

  lnePFA= new QLineEdit(QGroupBox_2,"NoName");
  lnePFA->setGeometry(90, w, 90, iw);
  lnePFA->setMinimumSize(0,0);
  QToolTip::add(lnePFA, i18n("Ftp proxy host name"));

  QLabel_3= new QLabel(QGroupBox_2,"NoName");
  QLabel_3->setGeometry(190, w, 40, iw);
  QLabel_3->setMinimumSize(0,0);
  QLabel_3->setText(i18n("Port:"));

  lnePFP= new QLineEdit(QGroupBox_2,"NoName");
  lnePFP->setGeometry(230, w, 40, iw);
  lnePFP->setMinimumSize(0,0);
  w += dw;

  QLabel_6= new QLabel(QGroupBox_2,"NoName");
  QLabel_6->setGeometry(sx, w, 260, iw);
  QLabel_6->setMinimumSize(0,0);
  QLabel_6->setText(i18n("No Proxy for:"));
  w += dw;

  lneNoProxy= new QLineEdit(QGroupBox_2,"NoName");
  lneNoProxy->setGeometry(sx, w, 260, iw);
  lneNoProxy->setMinimumSize(0,0);
  QToolTip::add(lneNoProxy, i18n("List of comma or space separated host names, glob expressions are accepted for grouping, like *.xxx.yyy, or xxx.*"));
  w += iw + ew;

  QGroupBox_2->setGeometry(sx, mw, 280, w);
  QGroupBox_2->setMinimumSize(0,0);
  QGroupBox_2->setTitle(i18n("Proxy"));
  mw += w + dmw;

  resize(300, w);
  setMinimumSize(300, w);
*/
}

void KDlgTransferWget1::slotSetProxy(bool on) {
  lneNoProxy->setEnabled(on);
  lnePFA->setEnabled(on);
  lnePFP->setEnabled(on);
  lnePHA->setEnabled(on);
  lnePHP->setEnabled(on);
}

/**  */
void KDlgTransferWget1::accept(){
  t.setNoProxyList(QStringList::split(",", lneNoProxy->text()));
  t.setProxyFTP(lnePFA->text());
  t.setProxyPortFTP(QString(lnePFP->text()).toInt());
  t.setProxyHTTP(lnePHA->text());
  t.setProxyPortHTTP(QString(lnePHP->text()).toInt());
  t.setReadTimeout(QString(lneReadTO->text()).toInt());
  t.setProxy(cbtProxy->isChecked());
  t.setHTTPCache(cbtCache->isChecked());
  t.setPassiveFtp(cbtPasv->isChecked());
  t.setSpeed(cmbSpeed->currentItem());
  t.setCmdPath(lneCmdPath->text());
}

/** check if the dialog is in an acceptable state */
bool KDlgTransferWget1::isAcceptable(){
  bool check;
  check = QString(lnePFP->text()).toInt();
  if (!check)
    return false;
  check = QString(lnePHP->text()).toInt();
  if (!check)
    return false;
  check = QString(lneReadTO->text()).toInt();
  if (!check)
    return false;
  QFileInfo f(lneCmdPath->text());
  if (!f.isExecutable())
    return false;
  return true;
}

/** update the dialog after a change in global checkbutton */
void KDlgTransferWget1::slotSetGlobal(bool on){
  cbtCache->setEnabled(!on);
  cbtPasv->setEnabled(!on);
  cbtProxy->setEnabled(!on);
  lneReadTO->setEnabled(!on);
  lneCmdPath->setEnabled(!on);
  cmbSpeed->setEnabled(!on);
  slotSetProxy(!on && t.getProxy());
}

#include "kdlgtransferwget1.moc"
