/***************************************************************************
                          kobjectimpl.cpp  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <qtextstream.h>
#include "kfactoryimpl.h"
#include "kobjectimpl.h"
#include "kcontainerimpl.h"


const char KObjectImpl::DOCID[] = "Object";
const char KObjectImpl::DOCTYPE[] = "<!DOCTYPE Object >";
const char KObjectImpl::MIMETYPE[][50] = { "application/" DOC "-object",
					 "text/x-" DOC "-object" };


KObjectImpl::KObjectImpl(int type) : QObject(), _container(0), _id(0),
  _modified(0), _global(0), _cfg_global(false), _type(type) {}

KObjectImpl::~KObjectImpl() {
  kdDebug(D_INI) << name() << ": destroy" << endl;
  kdFatal(isModified(MOD_ALL)) << name() << ": destroy modified " << _modified << endl;
  dom().clear();
}

bool KObjectImpl::isModified(ModType type) const { 
  return _modified & type;
}

void KObjectImpl::load(KContainerImpl *cont, const QDomElement &e) {
  kdDebug(D_INI) << e.attribute("Name") << ": load" << endl;
  if (e.tagName() != docId()
      || !e.hasAttribute("Id")
      || !e.hasAttribute("Name")
      || !e.hasAttribute("Type")) {
    throw DomError(name(), "load: malformed document", e);
    //kdFatal(D_INI) << "MALFORMED DOM:" << e.ownerDocument().toString() << endl;
  }
  _container = cont;
  _dom = e;
  _id = e.attribute("Id").toInt();
  setName(e.attribute("Name"));
  _global = (_container != 0 && _id != 0) ? 
    _container->findGlobal(e.attribute("Type").toInt()) : 0;
  loadData();
  if (isModified(MOD_ALL))
      update();
  kdDebug(D_INI) << name() << ": Object loaded" << endl;
  //<< dom().ownerDocument().toString() << "END DOM" << endl;
}

void KObjectImpl::loadData() {
  kdDebug(D_INI) << name() << ": Object loaddata" << endl;
  if (!dom().hasAttribute("GlobalCfg")) 
    setModified(MOD_ALL, PRP_NONE);
  _cfg_global = 
    dom().attribute("GlobalCfg", QString().setNum(id() != 0)).toInt();
}

void KObjectImpl::runPeriodically() {
  update();
}

void KObjectImpl::setModified(ModType type, PropMode prop, bool mod) {
  _modified = (mod ? type : 0) | (_modified & ~type);
  if (mod) {
    //kdDebug(D_RUN) << name() << ": MODIFIED = " << QString("%1").arg(_modified, 0, 16) << " PROP = " << QString("%1").arg(prop, 0, 16) << endl;
    if (!isRoot() && prop != PRP_NONE)
      container()->itemChanged(this, type, prop);
  }
}

QString KObjectImpl::typeStr() const {
  return KFactoryImpl::factory()->typeStr(type());
}

QDomDocument KObjectImpl::toDom() const {
  QDomDocument doc;
  QByteArray data;
  QTextStream s(data, IO_WriteOnly);
  // FIXME!!
  s << "<?xml version = '1.0'?><!DOCTYPE " << docId() << " [] >";
  dom().save(s, 0);
  if (!doc.setContent(data))
    //kdFatal(D_RUN) << name() << " ERROR IN DOM GENERATION:\n" << (const char*)data << endl;
    throw DomError(name(), "error in dom generation", doc);
  return doc;
}

void KObjectImpl::update() {
  if (isModified(MOD_STATE))
    updateState();
  if (isModified(MOD_CONF))
    updateConf();
}

void KObjectImpl::updateConf() {
  kdDebug(D_RUN) << name() << ": update conf" << endl;
  setModified(MOD_CONF, PRP_NONE, false);
}

void KObjectImpl::updateState() {
  kdDebug(D_RUN) << name() << ": update state" << endl;
  dom().setAttribute("GlobalCfg", (int)_cfg_global);
  setModified(MOD_STATE, PRP_NONE, false);
}

#include "kobjectimpl.moc"
