/***************************************************************************
                          ktmanager.h  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTMANAGER_H
#define KTMANAGER_H

#include <qdir.h>
#include <kurl.h>
#include "kcontainer.h"

class KTManagerImpl;
class KMManager;
class KTransfer;

/**Interface for container of transfer objects
  *@author Sergio Moretti
  */
class KTManager : public KContainer {
  friend class KObject;
  friend class KMManager;

public: 
  KTManager() {}

  /** document name */
  static const char * docId();
  /** dom document type */
  static const char * docType();
  /** mime type */
  static const char * mimeType(int i);

  KTransfer findGlobal(int type) const;
  /** returns the manager's title */
  QString title() const;
  /** kill all subprocess */
  void killAll();
  /** get the current bandwidth */
  int bandwidth() const;
  int mediumBandwidth() const;
  /** send a message to display */
  //void message(const QString &msg) = 0;
  /** add a new transfer wget type object */
  KTransfer itemNew(int type, const KURL &rmt, const KURL &lcl);
  // attribute management
  /** return autodownload mode */
  bool getAutoDownload() const;
  /** enable/disable autodownload */
  void setAutoDownload(bool m=true);
  bool getAutoRemove() const;
  void setAutoRemove(bool r);
  int getMaxConnection() const;
  void setMaxConnection(int c);
  int getMaxBandwidth() const;
  void setMaxBandwidth(int b);
  const QDir & getDownloadDir() const;
  void setDownloadDir(const QString &d);
  const QDir & getWorkingDir() const;
  void setWorkingDir(const QString &d);
  int getPriority() const;
  void setPriority(int p);
  int getDefaultType() const;
  void setDefaultType(int t);
  QString getLogFile() const;
  void setLogFile(const QString &f);

protected:
  KTManager(KTManagerImpl *impl);
  KTManagerImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
