/***************************************************************************
                          ktmanagerdrag.cpp  -  description
                             -------------------
    begin                : Sat Oct 21 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <qtextstream.h>
#include "ktransfer.h"
#include "ktmanagerdrag.h"


KTManagerDrag::KTManagerDrag(KTManager mngr, QWidget *dragSource, 
			     const char *name) 
  : QDragObject(dragSource, name), m(mngr) {
}

const char* KTManagerDrag::format(int i) const {
  kdDebug(D_RUN) << m.name() << ": drag format " << i << endl;
  switch (i) {
  case 0:
    return KTManager::mimeType(i);
  case 1:
    return "text/uri-list";
  }
  return 0;
}
  
QByteArray KTManagerDrag::encodedData(const char* mimetype) const {
  QByteArray data;
  QTextStream s(data, IO_WriteOnly);
  if (strcmp(mimetype, KTManager::mimeType(0)) == 0) {
    s << "<?xml version = '1.0'?>" << KTManager::docType() << endl;
    m.dom().save(s ,0);
  } else if (strcmp(mimetype, "text/uri-list") == 0) {
    QStrList lst;
    for (KTransfer t = m.itemFirst().toTransfer(); !t.isNull(); 
	 t = m.itemNext().toTransfer())
      lst.append(QUriDrag::unicodeUriToUri(t.remote().url())); //FIXME!!
    data = QUriDrag(lst, 0).encodedData("text/uri-list");
  } else {
    kdFatal(D_RUN) << m.name() << ": DRAG UNKNOWN MIME" << endl;
  }
  return data;
}

bool KTManagerDrag::canDecode(const QMimeSource *e) {
  return (e->provides(KTManager::mimeType(0)));
}

bool KTManagerDrag::decode(const QMimeSource *e, QDomDocument &dom) {
  kdDebug(D_RUN) << "KTManagerDrag: drag decode" << endl;
  QByteArray data;
  for (int i = 0; i < 1; i++)
    if (e->provides(KTManager::mimeType(i))) {
      kdDebug(D_RUN) << "KTManagerDrag: decode " << KTManager::mimeType(i) << endl;
      QByteArray data = e->encodedData(KTManager::mimeType(i));
      return dom.setContent(data);
    }
  return false;
}

