/***************************************************************************
                          ktmanagerimpl.h  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTMANAGERIMPL_H
#define KTMANAGERIMPL_H

#include <qdir.h>
#include <kurl.h>
#include "kcontainerimpl.h"
//#include "ktmanager.h"

class KTransferImpl;
class KTManager;

/**Container for KTransfer objects
  *@author Sergio Moretti
  */

class KTManagerImpl : public KContainerImpl  {
  
  Q_OBJECT

  friend class KTManager;
  friend class KObject;

public: 
  static const char DOCID[];
  static const char MIMETYPE[][50];
  static const char DOCTYPE[];

  virtual ~KTManagerImpl();

  /** document name */
  virtual const char * docId() const { return DOCID; }
  /** dom document type */
  virtual const char * docType() const { return DOCTYPE; }
  /** mime type */
  virtual const char * mimeType(int i) const { return MIMETYPE[i]; }

  /** returns the manager's title */
  QString title() const { return _title; }
  /** sets the title of the manager */
  void setTitle(const QString &t) { _title = t; }

  // items managements

  /** add a new transfer object */
  KTransferImpl * itemNew(int type, const KURL &rmt, const KURL &lcl);
  virtual void itemRemove(KObjectImpl *item);
  virtual bool isItemInsertable(const KObjectImpl *item);

  //KManager * manager() const;
  virtual void runPeriodically();
  /** kill all subprocess */
  virtual void killAll();
  /** get the current bandwidth */
  int bandwidth() const { return _bandwidth; }
  int mediumBandwidth() const { return _mediumBandwidth; }
  /** send a message to display */
  //void message(const QString &msg);

  // attribute management
  
  /** return autodownload mode */
  bool getAutoDownload() const { return _cfg_autoDownload; }
  /** enable/disable autodownload */
  void setAutoDownload(bool m=true);
  bool getAutoRemove() const { return _cfg_autoRemove; }
  void setAutoRemove(bool r) { _cfg_autoRemove = r; }
  int getMaxConnection() const { return _cfg_maxConnection; }
  void setMaxConnection(int c) { _cfg_maxConnection = c; }
  int getMaxBandwidth() const { return _cfg_maxBandwidth; }
  void setMaxBandwidth(int b) { _cfg_maxBandwidth = b; }
  QString getLogFile() const { return _cfg_logFile; }
  void setLogFile(const QString &l) { _cfg_logFile = l; }
  const QDir & getDownloadDir() const { return _cfg_downloadDir; }
  void setDownloadDir(const QString &d) { _cfg_downloadDir = d; }
  const QDir & getWorkingDir() const { return _cfg_workingDir; }
  void setWorkingDir(const QString &d) { _cfg_workingDir = d; }
  int getPriority() const { return _cfg_priority; }
  void setPriority(int p) { _cfg_priority = p; }
  int getDefaultType() const { return _cfg_defaultType; }
  void setDefaultType(int t) { _cfg_defaultType = t; }

  /** scan transfer list to delete completed transfers */
  virtual void scanForRemoving();
  /** scan list to find a transfer to run */
  virtual KTransferImpl* selectForRunning();

protected:
  KTManagerImpl(int type);
  virtual KObjectImpl * clone() const { return new KTManagerImpl(type()); }

  virtual void loadData();
  virtual void updateState();
  virtual void updateConf();
  
private: 
  /** mask parent itemNew */
  //KContainerImpl::itemNew;

  // State
  /** global bandwidth */
  int _bandwidth;
  /** global medium bandwidth */
  int _mediumBandwidth;
  /** title */
  QString _title;
  
  // Configuration Parameters
  /** automatic downloading */
  bool _cfg_autoDownload;
  /** when transfer complete, remove entry */
  bool _cfg_autoRemove;
  /** max BPS bandwidth */
  int _cfg_maxBandwidth;
  /** max open connection */
  int _cfg_maxConnection;
  /** write in log */
  QString _cfg_logFile;
  /** download directory */
  QDir _cfg_downloadDir;
  /** working directory */
  QDir _cfg_workingDir;
  /** priority */
  int _cfg_priority;
  /** default transfer type */
  int _cfg_defaultType;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
