/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#include <stdlib.h>
#include <string.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qsize.h>
#include <qtooltip.h>
#include <qdir.h>

#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kfiledialog.h>

#include "exportdlg.h"
#include "filters.h"



ExportDlg *exportdlg = 0;



ExportDlg::ExportDlg(QWidget *parent, const char *name) : KDialog (parent, name, false)
{
	QBoxLayout *vbox, *hbox, *fvbox, *fhbox;
	QGroupBox *gb;
	QPushButton *help, *ok, *cancel;
	QSize size;

	gotToolTips = false;

	vbox = new QVBoxLayout(this , marginHint());

	gb = new QGroupBox(i18n("Export to File"), this);
	fvbox = new QVBoxLayout(gb, 12);
	fvbox->addSpacing(8);
	fhbox = new QHBoxLayout();
	fvbox->addLayout(fhbox);
	file = new QLineEdit(gb);
	file->setMinimumWidth(240);
	file->setFixedHeight(file->sizeHint().height());
	file->setText("message.wav");
	fhbox->addWidget(file);

	browse = new QPushButton(gb);
	browse->setPixmap(SmallIcon("fileopen"));
	browse->setFixedSize(browse->sizeHint()+QSize(6, 6));	
	fhbox->addWidget(browse);
	
	fvbox->activate();

	vbox->addWidget(gb);
		
	hbox = new QHBoxLayout(8);
	vbox->addLayout(hbox);

	help = new QPushButton(i18n("&Help"), this);
	ok = new QPushButton(i18n("&OK"), this);
	ok->setDefault(true);
	cancel = new QPushButton(i18n("&Cancel"), this);
	size = help->sizeHint().expandedTo(ok->sizeHint().expandedTo(cancel->sizeHint()));

	help->setFixedSize(size);
	ok->setFixedSize(size);
	cancel->setFixedSize(size);

	hbox->addWidget(help);
	hbox->addStretch();
	hbox->addWidget(ok);
	hbox->addWidget(cancel);

	vbox->activate();

	connect(browse, SIGNAL(clicked()), SLOT(slotBrowse()));
	connect(help, SIGNAL(clicked()), SLOT(slotHelp()));
	connect(ok, SIGNAL(clicked()), SLOT(slotOk()));
	connect(cancel, SIGNAL(clicked()), SLOT(reject()));

	setCaption(i18n("Export"));
}


ExportDlg::~ExportDlg()
{
}


void ExportDlg::addToolTips(bool on)
{
	if (on == gotToolTips)
		return;

	gotToolTips = on;

	if (gotToolTips) {
		QToolTip::add(file, i18n("Name of file to export to"));
		QToolTip::add(browse, i18n("Select file to export to"));
	}
	else {
		QToolTip::remove(file);
		QToolTip::remove(browse);
	}
}	


void ExportDlg::exportMessage(const QString& name, uchar type)
{
	m_name = name;
	m_type = type;
	
	if (isVisible())
		raise();
	else
		show();
}


void ExportDlg::slotBrowse()
{
	QString s = KFileDialog::getSaveFileName(QDir::currentDirPath(), i18n("*.wav|WAV Files (*.wav)\n*|All Files (*)"), this);
	if (!s.isEmpty())
		file->setText(s);
}


void ExportDlg::slotHelp()
{
	kapp->invokeHelp("EXPORT-HELP");
}


void ExportDlg::slotOk()
{
	MLO2WavFilter filter;

	filter.setFile(m_name, m_type);

	kapp->setOverrideCursor(waitCursor);

	filter.convertFile(file->text());

	kapp->restoreOverrideCursor();
	
	hide();
}
