/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef EXPORTDLG_H
#define EXPORTDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qstring.h>

#include <kdialog.h>



class ExportDlg : public KDialog
{
	Q_OBJECT
public:
	ExportDlg(QWidget *parent = 0, const char *name = 0);
	~ExportDlg();

	void addToolTips(bool on);

	void exportMessage(const QString& name, uchar type);

protected slots:
	void slotBrowse();
	void slotHelp();
	void slotOk();

private:
	bool gotToolTips;

	QLineEdit *file;
	QPushButton *browse;

	QString m_name;
	uchar m_type;
};


extern ExportDlg *exportdlg;

#endif // EXPORTDLG_H
