/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef FILTERS_H
#define FILTERS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

#include <qstring.h>


class MLOFilter
{
public:
	MLOFilter();
	MLOFilter(const QString& infile, uchar type);
	virtual ~MLOFilter();

	void setFile(const QString& infile, uchar type);
	
	virtual bool convertStream(FILE *);
	bool convertFile(const QString& outfile);

private:
	void init();

protected:
	QString m_infile;
	uchar m_type;
};


class MLO2WavFilter : public MLOFilter
{
public:
	MLO2WavFilter();
	MLO2WavFilter(const QString& infile, uchar type);
	virtual ~MLO2WavFilter();

	virtual bool convertStream(FILE *stream);
};


#endif // FILTERS_H
