/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef SENDERALIASES_H 
#define SENDERALIASES_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qstring.h>
#include <qcstring.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <kdialog.h>


#define CALLER_ALIAS(x) (calleraliases->alias(x))


class EditAlias : public KDialog
{
	Q_OBJECT
public:
	EditAlias(QWidget *parent = 0, const char *name = 0);
	~EditAlias();

	void setCaller(QString caller_);
	QString caller();
	void setAlias(QString alias_);
	QString alias();

private:
	QLineEdit *m_caller;
	QLineEdit *m_alias;
};


inline void EditAlias::setCaller(QString caller_)
{	m_caller->setText(caller_); };


inline QString EditAlias::caller()
{	return m_caller->text(); };


inline void EditAlias::setAlias(QString alias_)
{	m_alias->setText(alias_); };


inline QString EditAlias::alias()
{	return m_alias->text(); };




class CallerAliases : public KDialog
{
	Q_OBJECT
public:
	CallerAliases(QWidget *parent = 0, const char *name = 0);
	~CallerAliases();

	void loadDir();
	void saveDir();

	void addToolTips(bool on);

public slots:
	QString alias(const QString& id_);
	void setAlias(const QString& id_);

protected slots:
	void selectionChangedSlot(QListViewItem *item);
	void executedSlot(QListViewItem *);
	void addItem();
	void editItem();
	void deleteItem();
	void slotHelp();

signals:
	void applyButtonPressed();

private:
	bool gotToolTips;

	QPushButton *add_item, *edit_item, *del_item;
	QListView *list;
};


extern CallerAliases *calleraliases;


#endif // SENDERALIASES_H
