/***************************************************************************
                          KNCAppCommand.cpp  -  description
                             -------------------
    begin                : Tue Sep 19 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <krun.h>
#include <kmessagebox.h>

#include "knc.h"
#include "knclistviewitem.h"
#include "userdialog.h"
#include "selectdialog.h"
#include "usercommands.h"


void KNCApp::slotCommandOpenUserMenu()
{
  UserDialog Dialog(_UserCommands);
  if (Dialog.exec())
  {
    _UserCommands->removeActions();
    _UserCommands->createActions();
    _UserCommands->saveEntries();
  }
}


void KNCApp::slotExecuteCommand(const QString& Cmd)
{
 KNCListView* View;
 QString Command = Cmd;
 int pos = 0;

 pos = Command.find("%", 0);

 while (pos != -1 && (int)Command.length() >= pos + 2)
 {
   int bInsert = 0;
   QString InsertString;

   QChar FirstChar = Command[pos+1];
   QChar SecondChar  = Command[pos+2];

   if (FirstChar == 'a') {View = _ActListView;}
   else if (FirstChar == 'l') {View = _LeftListView;}
   else if (FirstChar == 'r') {View = _RightListView;}
   else if (FirstChar == 's')
   {
     QString MessageText;
     int bpos = 0;
     if (SecondChar == '(')
     {
        bpos = Command.find(")", pos);
        if (bpos != 0)
          MessageText = Command.mid(pos+3, bpos - (pos+3));
     }
     SelectDialog Dialog(0, "", MessageText);
     if (!Dialog.exec()) return;
     InsertString = Dialog.getText();
     SecondChar = '!';
     if (bpos) bInsert = (bpos - pos) + 1;
     else bInsert = 2;
   }
   else {KMessageBox::error(NULL, i18n("Your configuration is malformed. Please check."));return;}


   if (SecondChar == 'f')
   {
     if (View->currentItem())
     {
       InsertString = "\"" + ((KNCListViewItem*) View->currentItem())->getFileItem()->name() + "\"";
       bInsert = 3;
     }
     else {KMessageBox::error(NULL, i18n("You cannot call this command now."));return;}
   }
   else if (SecondChar == 'F')
   {
     if (View->currentItem())
     {
       InsertString = "\"" + ((KNCListViewItem*)View->currentItem())->getFileItem()->url().path() + "\"";
       bInsert = 3;
     }
     else {KMessageBox::error(NULL, i18n("You cannot call this command now."));return;}
   }
   else if (SecondChar == 'l')
   {
     KURL::List URLs = View->getSelectedURLs();
     for (KURL::List::Iterator it = URLs.begin();it != URLs.end();it++)
     {
       InsertString += "\"" + (*it).fileName() + "\" ";
       bInsert = 3;
     }
   }
   else if (SecondChar == 'L')
   {
     KURL::List URLs = View->getSelectedURLs();
     for (KURL::List::Iterator it = URLs.begin();it != URLs.end();it++)
     {
       InsertString += "\"" + (*it).path() + "\" ";
     }
       bInsert = 3;
   }
   else if (SecondChar == 'd')
   {
     InsertString = "\"" + View->getURL().path() + "\"";
     bInsert = 3;
   }

   if (bInsert > 0)
   {
     Command.remove(pos, bInsert);
     Command.insert(pos, InsertString);
     pos += InsertString.length();
   }

   pos = Command.find("%", pos);
 }

 KRun::runCommand(Command, Command, "");
}
