/***************************************************************************
                          knccommandtoolbar.cpp  -  description
                             -------------------
    begin                : Wed Aug 30 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qdir.h>

#include <klineedit.h>
#include <kshellcompletion.h>
#include "knccommandtoolbar.h"

KNCCommandToolBar::KNCCommandToolBar(QWidget *parent, const char *name )
  : KToolBar(parent,name)
{
 _Edit = new KLineEdit(this);
 _Compl = new KShellCompletion();
 _Edit->setCompletionObject( _Compl );
 setFullSize(true);
}


KNCCommandToolBar::~KNCCommandToolBar()
{
 delete _Edit;
}

void KNCCommandToolBar::slotSetDirectory(const KURL& URL)
{
 if (URL.protocol() == "file") _Compl->setDir(URL.path());
 else _Compl->setDir(QDir::homeDirPath());
}

void KNCCommandToolBar::resizeEvent(QResizeEvent* e)
{
 int w = e->size().width() - 15;
 _Edit->resize(w, _Edit->height());
 _Edit->move(12, _Edit->y());
}