/***************************************************************************
                          usercommands.cpp  -  description
                             -------------------
    begin                : Tue Sep 19 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qiconset.h>
#include <qpopupmenu.h>

#include <kconfig.h>
#include <krun.h>

#include "usercommands.h"

UserCommands::UserCommands(KConfig* Config, KActionCollection* Coll, QPopupMenu* Menu)
  : _Config(Config), _Coll(Coll), _Menu(Menu)
{
 loadEntries();
 createActions();
 _Actions.setAutoDelete(true);
}

UserCommands::~UserCommands()
{
 saveEntries();
}

void UserCommands::loadEntries()
{
 _Config->setGroup("UserPreferences");
 int NumEntries = _Config->readNumEntry("NumEntries");
 for (int i = 0; i < NumEntries;i++)
 {
   _Config->setGroup(QString("UserPreferences: ") + QString().setNum(i));
   UserCommandEntry Entry;
   Entry._Name = _Config->readEntry("Name");
   Entry._Command = _Config->readEntry("Command");
   Entry._IconName = _Config->readEntry("Icon Name");
   _Commands.append(Entry);
 }
}

void UserCommands::saveEntries()
{
 _Config->setGroup("UserPreferences");
 int NumEntries = _Commands.count();
 _Config->writeEntry("NumEntries", NumEntries);
 for (int i = 0; i < NumEntries;i++)
 {
   _Config->setGroup(QString("UserPreferences: ") + QString().setNum(i));
   UserCommandEntry Entry;
   _Config->writeEntry("Name", _Commands[i]._Name);
   _Config->writeEntry("Command", _Commands[i]._Command);
   _Config->writeEntry("Icon Name", _Commands[i]._IconName);
 }
}

void UserCommands::addEntry(const QString& Name, const QString& Command, const QString& IconName)
{
 if (_Commands.contains(Name))
 {
//  KMessageBox::
   return;
 }
 UserCommandEntry Entry(Name, Command, IconName);
 _Commands.append(Entry);
}

void UserCommands::removeEntry(const QString& Name)
{
 QValueList<UserCommandEntry>::Iterator it = _Commands.find(Name);
 if (it != _Commands.end()) _Commands.remove(it);
}

void UserCommands::createActions()
{
 QValueList<UserCommandEntry>::Iterator it = _Commands.begin();

 for (;it != _Commands.end();it++)
 {
   KAction* Action = new KAction((*it)._Name, (*it)._IconName, 0, this, SLOT(slotCommandSelected()),
                                _Coll, (*it)._Name);
   _Actions.append(Action);
   Action->plug(_Menu);
 }
}

void UserCommands::removeActions()
{
 QListIterator<KAction> it (_Actions);

 for (;it.current();++it)
 {
   it.current()->unplug(_Menu);
   _Actions.remove(it);
 }
 _Menu->clear();
 _Actions.clear();
}

void UserCommands::slotCommandSelected()
{
  QValueList<UserCommandEntry>::Iterator it = _Commands.find(QString(sender()->name()));
  if (it != _Commands.end())
  emit executeCommand((*it)._Command);
}