/***************************************************************************
                          mybroswerinfo.cpp  -  description
                             -------------------
    begin                : Thu Mar 29 2001
    copyright            : (C) 2001 by Jochen Schmitt
    email                : Jochen@herr-schmitt.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mybrowserinfo.h"
#include <kconfig.h>
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>
#include <kapp.h>

#include <sys/stat.h>

BROWSER_INFO browser_info[] =
 	{ { "konqueror", "Konqueror", "kfmclient openURL" },
 	  { "netscape", "Netscape Communicator", "netscape-communicator"},
    { "mozila", "Mozilla", "mozilla"},														
   	{ 0, 0, 0 } };

static int ind;

MyBrowserInfo::MyBrowserInfo(){
	KConfig *config = kapp->config();
	config->setGroup("Browser");
	mbrowser = config->readEntry("Exec", "");
	moldbrowser = mbrowser;
}

MyBrowserInfo::~MyBrowserInfo(){
}

void MyBrowserInfo::getBrowser(QListBox *l, char *pfad)
{
	char buffer[256];
	
	strcpy(buffer,pfad);
	strcat(buffer,"/");

	char *fnamep = strchr(buffer, '\0');
	
	BROWSER_INFO *workp = browser_info;
	
	while(workp->desc != NULL)
	 {

	 	strcpy(fnamep, workp->fname);

	 	char *cp = strchr(fnamep, ' ');
	 	
	 	if(cp != 0L)
	 		*cp = '\0';
	 		
	 	struct stat file_stat;

		if(stat(buffer, &file_stat) == 0)
		{
			
	 		if(S_ISREG(file_stat.st_mode) != 0)
	 		 {
	 				if(access(buffer, X_OK) == 0)
	 				{
		      	l->insertItem(workp->desc);
		      	if(mbrowser == workp->tag)
		      	{
		      		ind = l->count() - 1;
		      	}
		      }
		      	
	 	   }
	 	}

	 	workp++;
	 }
}
	 	
void MyBrowserInfo::fillListbox(QListBox *l)
{
	char *env = getenv("PATH");
	
	char *allocp = (char *)malloc(strlen(env)+1);
	char *tempp = allocp;
	
	ind = -1;
	
	strcpy(tempp,env);
	
	while(true)
	{
	
		char *nextp;
		
		if((nextp = strchr(tempp, ':')) == NULL)
			break;
	
		*nextp = '\0';
		getBrowser(l,tempp);
		tempp = nextp + 1;
	
	}
	
	if(ind > -1)
		l->setSelected(ind, true);
		
	free(allocp);
}
	
bool MyBrowserInfo::Exec(const QString &arg)
{
	int i;
	char buffer[1024];
	
	QString zeile;
	QString lzeile;
	QString url;
	
	if(*mbrowser == 0)
		return false;
		
	QFile *datei = new QFile(arg);
	datei->open(IO_ReadOnly);
	
	QTextStream *stream = new QTextStream(datei);
	
	zeile = stream->readLine();
		
	if(zeile.isNull())
		return false;
		
	zeile = zeile.stripWhiteSpace();
	zeile = zeile.lower();
	
	if(zeile != QString("[internetshortcut]"))
		return false;
		
	while(true)
	{
		zeile = stream->readLine();
		
		if(zeile == QString(""))
			return false;
			
		if(zeile.isNull())
			return false;
		
		zeile = zeile.stripWhiteSpace();
		
		if(zeile.left(1) == QString(";"))
			continue;
			
		if(zeile.left(1) == QString("["))
			return false;
			
		lzeile = zeile.lower();
		
		i = lzeile.find('=');
		lzeile = lzeile.mid(0,i);
		
		if(lzeile == QString("url")) {
			url = zeile.mid(i+1);
			break;
		}
	}
	
	BROWSER_INFO *workp = browser_info;
	
	while(workp->tag != 0)
	{
		if(workp->tag == mbrowser)
		{
			strcpy(buffer,workp->fname);
			break;
		}
		workp++;
	}
	
	strcat(buffer, " ");
	strcat(buffer, url);
	return(system(buffer) == 0);
	
}/** No descriptions */
void MyBrowserInfo::setSelected(const QString &text){
	BROWSER_INFO *workp = browser_info;
	while(workp->desc != 0)
	{
		QString temp = QString(workp->desc);
		if(text == temp)
		{
			mbrowser = QString(workp->tag);
			return;
		}
		workp++;
	}
}

/** No descriptions */
void MyBrowserInfo::saveProfile(){
	KConfig *config = kapp->config();
	config->setGroup("Browser");
	config->writeEntry("Exec", mbrowser);
}

/** No descriptions */
bool MyBrowserInfo::changed(){
	return (mbrowser != moldbrowser);
}

#include "mybrowserinfo.moc"
