// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: kwatch.cpp,v 1.4 2000/12/04 21:20:47 mj Exp $
 *
 * Class for kwatch application
 *
 *****************************************************************************
 * Copyright (C) 2000
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include <stdio.h>

#include "kwatch.h"
#include "prefs.h"

#include <qtimer.h>
#include <qfile.h>
#include <qdatetime.h>
#include <qrect.h>
#include <qpoint.h>
#include <qsize.h>

#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kkeydialog.h>
#include <kaccel.h>
#include <kconfig.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kmessagebox.h>

#include <netwm.h>



kwatch::kwatch()
    : KMainWindow( 0, i18n("KDE Logfile Viewer") ),
      m_popup(0), m_log(0), m_prefs(0)
{
    // initialize
    readConfig();
//     setGeometry(m_cf.geometry);
    resize(m_cf.geometry.size());
    move(m_cf.geometry.topLeft());

    // log widget
    m_log = new KLogWidget(this, m_cf);
    setCentralWidget(m_log);
    
    // UI
    setupActions();

    // and a status bar
    //statusBar()->show();

    show();

    // log startup
    logtime(i18n("kwatch started"));
}



kwatch::~kwatch()
{
    fprintf(stderr, "~kwatch()\n");
    
//    delete m_popup;
    if(m_log)
	delete m_log;
    if(m_prefs)
	delete m_prefs;
}



void kwatch::setupActions()
{
    KStdAction::quit       (this, SLOT(quit()),
			    actionCollection());
    KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()),
			    actionCollection());
    KStdAction::preferences(this, SLOT(optionsPreferences()),
			    actionCollection());

    new KAction(            i18n("Reopen files"), 0,
			    this, SLOT(reopen()),
			    actionCollection(), "file_reopen");

    createGUI();

//    m_popup = (QPopupMenu *)factory()->container("rb_popup", this); 
}



void kwatch::quit()
{
    fprintf(stderr, "kwatch::quit()\n");

    saveConfig();
    kapp->quit();
}



void kwatch::reopen()
{
    fprintf(stderr, "kwatch::reopen()\n");

    m_log->reopen();
}



void kwatch::logtime(const QString &s)
{
    QDateTime t = QDateTime::currentDateTime();
    m_log->moreText(0, t.toString().mid(4,15) + " " + s + "\n");
}



void kwatch::saveConfig()
{
    saveProperties(kapp->config());
}

void kwatch::saveProperties(KConfig *config)
{
    m_cf.geometry = QRect(pos(), size());
    fprintf(stderr, "kwatch: frame geometry=%d,%d,%d,%d\n",
	    m_cf.geometry.x(), m_cf.geometry.y(),
	    m_cf.geometry.width(), m_cf.geometry.height());

//     m_cf.geometry = geometry();
    
    m_cf.save(config);
}



void kwatch::readConfig()
{
    readProperties(kapp->config());
}

void kwatch::readProperties(KConfig *config)
{
    m_cf.read(config);
}



void kwatch::closeEvent(QCloseEvent *e)
{
    fprintf(stderr, "closeEvent()\n");

    saveConfig();
    KMainWindow::closeEvent(e);
}



void kwatch::optionsConfigureKeys()
{
    KKeyDialog::configureKeys(actionCollection(), "kwatchui.rc");
}



void kwatch::optionsPreferences()
{
    fprintf(stderr, "kwatch::optionsPreferences()\n");

    m_prefs = new kwatchPrefs(this, m_cf);
    
    if(m_prefs->exec())
    {
	fprintf(stderr, "kwatch::optionsPreferences() - exec\n");
	m_prefs->setMainConf();
	m_log->updateConf();
    }

    delete m_prefs;
    m_prefs = 0;
}
