/**
 * mainwidget.h
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef KCFGCREATOR_MAINWIDGET_H
#define KCFGCREATOR_MAINWIDGET_H

#include <qwidget.h>

class KListView;
class QListViewItem;
class KURL;

namespace KCfgCreator
{
    class AppItem;
    class Manager;
    class EditorWidget;
    class CreatorKCfg;
    class ApplicationToken;

    class MainWidget : public QWidget
    {
        Q_OBJECT
    public:
        MainWidget( QWidget *parent );

    public slots:
        void newConfig();
        void parseFile();
        void fromRcFile();
        void save();
        void addEntry();
        void removeEntry();
        void preferences();

        void openKCfgcFile( const KURL& );
        void openKCfgFile( const KURL& );
        void openRCFile( const KURL& );

    protected slots:
        void slotDone( ApplicationToken*, const QCString& );
    private:
        friend class Manager;
        KListView* listView() const {
            return m_entryView;
        }
        EditorWidget* editor() const {
            return m_editWidget;
        }
    private:
        void initGUI();
    private:
        KListView    *m_entryView;
        EditorWidget *m_editWidget;
        Manager *m_manager;
        CreatorKCfg *m_cfgCreator;
    };
}

#endif
