/**
 * memento.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "memento.h"
#include "entrytoken.h"
#include "grouptoken.h"
#include "applicationtoken.h"

namespace KCfgCreator
{

Memento::Memento( Token* token )
    : m_token( token ), m_tokenName( token->name() )
{
    m_token->incrementModificationCount();
}

Memento::~Memento()
{
}

void
Memento::restore()
{
    m_token->setName( m_tokenName );
    m_token->decrementModificationCount();
}

EntryMemento::EntryMemento( EntryToken* token, const QString& data,
                            StringSetter setter )
    : Memento( token ), m_strData( data ),
      m_setter1( setter ), m_setter2( 0 )
{
}

EntryMemento::EntryMemento( EntryToken* token, const QStringList& data,
                            StringListSetter setter )
    : Memento( token ), m_strListData( data ),
      m_setter1( 0 ), m_setter2( setter )
{
}

void
EntryMemento::restore()
{
    EntryToken *token = static_cast<EntryToken*>( m_token );
    token->disableUndo();

    if ( m_setter1 )
        (token->*m_setter1)( m_strData );
    else if ( m_setter2 )
        (token->*m_setter2)( m_strListData );

    token->enableUndo();
}

GroupMemento::GroupMemento( GroupToken* token, EntryToken* entry, Change change )
    : Memento( token ), m_changedToken( entry ), m_change( change )
{
}

void
GroupMemento::restore()
{
    GroupToken *token = static_cast<GroupToken*>( m_token );

    if( m_change == Added ) {
        token->deleteEntry( m_changedToken );
    } else {
        token->createEntry( m_changedToken->name(),
                            m_changedToken->valueAsString() );
        delete m_changedToken;
    }

}

}//end namespace Konfig
