/**
 * treeitems.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "treeitems.h"

#include "entrytoken.h"
#include "grouptoken.h"
#include "token.h"


#include <kiconloader.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

#include <qpixmap.h>

namespace KConfigEditor
{

ConfItem::ConfItem( KListView *parent, const QString &name )
    : KListViewItem( parent, name )
{
}

ConfItem::ConfItem( ConfItem *parent, Token *token )
    : KListViewItem( parent, token->name() )
{
}

EntryItem::EntryItem( GroupItem *parent, EntryToken *token )
    : ConfItem( parent, token ),
      m_token( token )
{
    setRenameEnabled( 1, true );
    setText(0,token->name());
    /*
    setText(1, token->valueAsString());
    if( token->fromEnvironment() )
        setPixmap(2, ::BarIcon("button_ok"));
    else
        setPixmap(2, ::BarIcon("button_cancel"));
    if( token->immutable() )
        setPixmap(3, ::BarIcon("lock"));
    else
        setPixmap(3, ::BarIcon("unlock"));
    setText(4, token->defaultValue() );
    */
}

void
EntryItem::update()
{
    setText( 0, m_token->name() );
    setText( 1, m_token->valueAsString() );
}

QString
EntryItem::name() const
{
    return m_token->name();
}

QString
EntryItem::value() const
{
    return m_token->valueAsString();
}

GroupItem::GroupItem( ConfItem *parent, GroupToken *token )
    : ConfItem( parent, token ), m_token( token )
{
}

QString
GroupItem::name() const
{
    return m_token->name();
}

EntryToken*
GroupItem::entry( const QString &key )
{
    return m_token->entry( key );
}

GroupToken*
GroupItem::group() const
{
    return m_token;
}

void
GroupItem::updateIcon()
{
    KIconLoader *loader = KGlobal::instance()->iconLoader();
    QString name = m_token->name();

    QPixmap pm = loader->loadIcon( name, KIcon::Small, 0, KIcon::DefaultState, 0,
                                   true );

    //kdDebug()<<"Name "<<name<<" " << pm.isNull() <<endl;

    if ( pm.isNull() && name.endsWith( ".rc" ) ) {
        name = name.left( name.length() - 3 );
        pm = loader->loadIcon( name, KIcon::Small, 0, KIcon::DefaultState, 0,
                               true );
        //kdDebug()<<"Name "<<name<<" " << pm.isNull() <<endl;
    }

    if ( pm.isNull() && name.endsWith( "rc" ) ) {
        name = name.left( name.length() - 2 );
        pm = loader->loadIcon( name, KIcon::Small, 0, KIcon::DefaultState, 0,
                               true );
        //kdDebug()<<"Name "<<name<<" " << pm.isNull() <<endl;
    }


    if ( pm.isNull() ) {
        pm = loader->loadIcon( "configure", KIcon::Small, 0, KIcon::DefaultState, 0,
                               true );
    }
    if ( !pm.isNull() )
        setPixmap( 0, pm );
}


ProtocolItem::ProtocolItem( KListView *parent, const QString &name )
    : ConfItem( parent, name )
{
    if ( name == "kde" )
        setPixmap( 0, SmallIcon( "kde" ) );
    else if ( name == "gnome" )
        setPixmap( 0, SmallIcon( "gnome-apps" ) );
}

} //end namespace KConfigEditor

