/**
 * configurationview.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "configurationview.h"

#include "entrytoken.h"
#include "grouptoken.h"
#include "treeitems.h"

#include <kurl.h>
#include <klocale.h>

using namespace KConfigEditor;

ConfigurationView::ConfigurationView( QWidget *parent )
    : KListView( parent )
{
    setRootIsDecorated( true );
    addColumn( i18n( "Option" ) );
}

void ConfigurationView::attach( GroupToken *token )
{
    token->attach( this );
    m_items.insert( token->url().url(), token );
}

void ConfigurationView::attach( EntryToken *token )
{
    token->attach( this );
    m_items.insert( token->url().url(), token );
}

Token * ConfigurationView::token( const KURL &url )
{
    return m_items[ url.url() ];
}

ConfItem * ConfigurationView::item( const KURL &url )
{
    Token *token = m_items[ url.url() ];
    return token ? token->view() : 0;
}

ProtocolItem * ConfigurationView::protocolItem( const QString &protocol )
{
    ProtocolItem *item = m_protocols[ protocol ];
    if ( !item ) {
        item = new ProtocolItem( this, protocol );
        m_protocols.insert( protocol, item );
    }
    return item;
}

#include "configurationview.moc"
