/**
 * entryitem.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef ENTRYITEM_H
#define ENTRYITEM_H

class EntryItem
{
public:
    enum Type {
        String,
        Password,
        StringList,
        Font,
        Rect,
        Size,
        Color,
        Point,
        Int,
        UInt,
        Bool,
        Double,
        DateTime,
        Int64,
        UInt64,
        IntList,
        Enum,
        Path,
        Invalid
    };
public:
    EntryItem() {}
    EntryItem( const KURL &url, ItemType type,
                const QString &name, const QVariant &value,
                const QString &shortDesc = QString::null,
                const QString &longDesc = QString::null )
        : m_url( url ), m_type( type ), m_name( name ),
          m_value( value ), m_shortDesc( shortDesc ),
          m_longDesc( longDesc )
    {}


    KURL m_url;

    ItemType m_type;
    QString  m_name;
    QVariant m_value;

    QString m_shortDesc;
    QString m_longDesc;
};

#endif
