/*
 *   Copyright (C) 2003 Crissi <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */

#include "kpum.h"
#include "useradmin.h"

#include <qlabel.h>
#include <qpixmap.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kaboutkde.h>
#include <kaboutapplication.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <kstatusbar.h>
#include <kaboutdata.h>
#include <kaboutapplication.h>
#include <kaboutkde.h>

KPum::KPum()
        : KMainWindow( 0, "KPum" )
{
    // set the shell's ui resource file
    setXMLFile("kpumui.rc");

    setIcon(QPixmap("kpum.png"));

    mainMenu = new KMenuBar(this);
    KPopupMenu *filemenu = new KPopupMenu(this);

    menuBar()->insertItem( i18n("&File"), filemenu );

    filemenu->insertItem(i18n("&Quit"),  this, SLOT(close()), CTRL+Key_Q );
    mainMenu->insertItem(i18n("&Help"), helpMenu( QString::null, false ));
    UserAdmin *user_admin = new UserAdmin(this);
    user_admin->setFocus();
    setCentralWidget( user_admin );
    statusBar()->message( i18n("Ready"), 2000 );


 //   this->showMaximized();
  //  userAdmin->showMaximized();

}

KPum::~KPum()
{}



#include "kpum.moc"
