/*
 *  Copyright (C) 2003 Ole Behrmann <obehrmann@hbg-bremen.de>
 *  Copyright (C) 2003 Christoph Thielecke <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */

#include "useradmin.h"

#include <kconfig.h>
#include <qbuttongroup.h>
#include "currentuserinfo.h"
#include "kactivelabel.h"
#include <qmessagebox.h>
#include <kpopupmenu.h>
#include <kmainwindow.h>
#include <kstatusbar.h>
#include "chpassdialog.h"

UserAdmin::UserAdmin(QWidget *parent, const char *name ) : UserAdminBase(parent,name)
{

    initUserList();

    //connections
    connect (lstMainUser, SIGNAL(executed(QListViewItem*)),
            this, SLOT(onListViewClicked(QListViewItem*)));

    connect (lstMainUser, SIGNAL(contextMenu (KListView *, QListViewItem *, const QPoint &)),
            this, SLOT(showContextMenu(KListView *, QListViewItem* ,const QPoint &)));

    // lstMainUser->setColumnWidthMode(1,QListView::Maximum);
    // lstMainUser->setColumnWidth(1,10);
    //lstMainUser->setResizeMode(QListView::AllColumns);

    // init config file
    config = new KConfig("kcmpureftpdUseradminrc",false,false);

    // init global variables
    urlSystemGroupFile="/etc/group";
    urlSystemPasswdFile="/etc/passwd";
    useSystemFilesPaths=true;
    usePureftpdFilesPaths=true;
    urlPureftpdPasswdFile="/etc/pure-ftpd/pureftpd.passwd";
    urlPureftpdGroupFile="/etc/pure-ftpd/pureftpd.group";
    urlPureftpdDatabaseFile="/etc/pure-ftpd/pureftpd.pdb";
    usePureftpdStandardFilePaths=true;
    useNotifyStandard=true;
    notifyUserDel=true;
    notifyUserModify=true;
    notifyUserAdd=true;
    useCleanStandard=true;
    clearUserEdit=true;
    clearUserAdd=true;

    // load old config from kcmpureftpdUseradminrc
    loadConfig();

    //	 QMessageBox::information (NULL,"info","Username: "+userInfo.getCurrentUser());

    CurrentUserInfo userInfo;

    QString systemUser = userInfo.getCurrentUser();
    labelUser->setText(i18n("running as: ")+userInfo.getCurrentUser());

    initUserList();
    slotRefresh();
    /*
    KMessageBox::sorry(this,i18n("urlSystemGroupFile: "+urlSystemGroupFile+" \n"+
    "urlSystemPasswdFile: "+urlSystemPasswdFile+"\n"+
    "useSystemFilesPaths: "+boolToString(usePureftpdFilesPaths)+"\n"+
    "usePureftpdFilesPaths: "+boolToString(usePureftpdFilesPaths)+"\n"+
    "urlPureftpdPasswdFile: "+urlPureftpdPasswdFile+"\n"+
    "urlPureftpdGroupFile: "+urlPureftpdGroupFile+"\n"+
    "urlPureftpdDatabaseFile: "+urlPureftpdDatabaseFile+"\n"+
    "usePureftpdStandardFilePaths: "+boolToString(usePureftpdStandardFilePaths)+"\n"+
    "useNotifyStandard: "+boolToString(useNotifyStandard)+"\n"+
    "notifyUserDel: "+boolToString(notifyUserDel)+"\n"+
    "notifyUserModify: "+boolToString(notifyUserAdd)+"\n"+
    "notifyUserAdd: "+boolToString(notifyUserAdd)+"\n"+
    "useCleanStandard: "+boolToString(useCleanStandard)+"\n"+
    "clearUserEdit: "+boolToString(clearUserEdit)+"\n"+
    "clearUserAdd: "+boolToString(clearUserAdd)));
      */
}

QString UserAdmin::boolToString( bool b )
{
    QString result;
    if ( b )
        result = "True";
    else
        result = "False";
    return result;
}


UserAdmin::~UserAdmin()
{}

/*
 * Reads the config from rc file (kcmpureftpdUseradminrc) and set global variables
 */
void UserAdmin::loadConfig()
{
    // jump to group SystemPaths
    config->setGroup("SystemPaths");

    // read system group file, system password file and standard system files
    urlSystemGroupFile = config->readEntry("System Group File",QString::null);
    urlSystemPasswdFile = config->readEntry("System Password File",QString::null);
    useSystemFilesPaths = config->readBoolEntry("Use Standard System files Paths",true);

    // jump to group PureftpdPaths
    config->setGroup("PureftpdPaths");

    // read standard pureftpd paths, pureftpd password file, pureftpd group file and pureftpd
    // database file (virtual users)
    usePureftpdStandardFilePaths = config->readBoolEntry("Use Standard Pureftpd files Paths",true);
    urlPureftpdPasswdFile = config->readEntry("Pureftpd Password File",QString::null);
    urlPureftpdGroupFile = config->readEntry("Pureftpd Group File",QString::null);
    urlPureftpdDatabaseFile = config->readEntry("Pureftpd Group File",QString::null);

    // jump to group Notify
    config->setGroup("Notify");

    // read standard notify, notify on user add, user modify an user del
    useNotifyStandard = config->readBoolEntry("Use Standard Notify",true);
    notifyUserAdd = config->readBoolEntry("Notify on user add",true);
    notifyUserModify = config->readBoolEntry("Notify on user modify",true);
    notifyUserDel = config->readBoolEntry("Notify on user del",true);

    // jump to group Clean
    config->setGroup("Clean");

    // read standard cleanup, clear on user add, user edit
    useCleanStandard = config->readBoolEntry("Use Standard Clean Up",true);
    clearUserAdd = config->readBoolEntry("Clear on user add",true);
    clearUserEdit = config->readBoolEntry("Clear on user edit",true);

}


void UserAdmin::initUserList()
{

    //open user file and get values
    QFile flGetUsers(urlPureftpdPasswdFile);
    if ( flGetUsers.open(IO_ReadOnly))
    {

        QTextStream txtsGetUser( &flGetUsers );

        lstMainUser->setAllColumnsShowFocus(TRUE);

        QString readUser;
        QString login;
        QString fullName;
        QString passwd;
        QString userUid;
        QString userGid;
        QString homeDir;
        QString chroot;
        QString upBand;
        QString downBand;
        QString upRat;
        QString downRat;
        QString timeRest;
        QString maxConn;
        QString maxFiles;
        QString allLocIp;
        QString denLocIp;
        QString allCliIp;
        QString denCliIp;
        QString maxSize;


        while (!txtsGetUser.eof())
        {
            readUser = txtsGetUser.readLine();

            int index;

            index = readUser.find(":");

            //get login of user
            login  = readUser;
            login.truncate(index);

            readUser.remove(0,index+1);

            //remove hashed password
            index = readUser.find(":");
            passwd = readUser;
            passwd.truncate(index);

            readUser.remove(0,index+1);

            //get user uid
            index = readUser.find(":");
            userUid = readUser;
            userUid.truncate(index);

            readUser.remove(0,index+1);

            //get user gid
            index = readUser.find(":");
            userGid = readUser;
            userGid.truncate(index);

            readUser.remove(0,index+1);

            //get full Name
            index = readUser.find(":");
            fullName = readUser;
            fullName.truncate(index);

            if (fullName.isEmpty() || fullName.contains("0"))
            {
                fullName = i18n("-");
            }

            readUser.remove(0,index+1);

            //get user home dir
            index = readUser.find(":");
            homeDir = readUser;
            homeDir.truncate(index);

            if (homeDir.find("./") != -1)
            {
                chroot = i18n("Yes");
                homeDir.truncate(homeDir.length()-2);
            }
            else
            {
                chroot = i18n("No");
            }


            readUser.remove(0,index+1);

            //get user max. upload Bandwidth
            index = readUser.find(":");
            upBand = readUser;
            upBand.truncate(index);

            if (!upBand.isEmpty())
            {
                int calcUpBand = upBand.toInt();
                calcUpBand = calcUpBand / 1024;
                upBand = QString::number(calcUpBand) + "Kbit/s";
            }
            else if (upBand.isNull() || upBand.isEmpty())
            {
                upBand = i18n("-");
            }

            readUser.remove(0,index+1);

            //get user max. download Bandwidth
            index = readUser.find(":");
            downBand = readUser;
            downBand.truncate(index);

            if (!downBand.isEmpty())
            {
                int calcDownBand = downBand.toInt();
                calcDownBand = calcDownBand / 1024;
                downBand = QString::number(calcDownBand) + "Kbit/s";
            }
            else
            {
                downBand = i18n("-");
            }
            readUser.remove(0,index+1);

            //get upload ratio
            index = readUser.find(":");
            upRat = readUser;
            upRat.truncate(index);

            readUser.remove(0,index+1);

            //get download ratio
            index = readUser.find(":");
            downRat = readUser;
            downRat.truncate(index);

            readUser.remove(0,index+1);

            //put ratio together
            QString ratOut;
            if (!upRat.isEmpty())
            {
                ratOut = upRat + ":" + downRat;

            }
            else
            {
                ratOut = i18n("-");
            }

            //get max connections for user
            index = readUser.find(":");
            maxConn = readUser;
            maxConn.truncate(index);

            if (maxConn.isEmpty())
            {
                maxConn = i18n("-");
            }

            readUser.remove(0,index+1);

            //get files quota
            index = readUser.find(":");
            maxFiles = readUser;
            maxFiles.truncate(index);

            if (maxFiles.isEmpty() || maxFiles.contains("0"))
            {
                maxFiles = i18n("-");
            }

            readUser.remove(0,index+1);

            //get size quota
            index = readUser.find(":");
            maxSize = readUser;
            maxSize.truncate(index);

            if (!maxSize.isEmpty())
            {
                int calcMaxSize = maxSize.toInt();
                calcMaxSize = calcMaxSize / 1024 / 1024;
                maxSize = QString::number(calcMaxSize) + "MB";
            }
            else
            {
                maxSize = i18n("-");
            }

            readUser.remove(0,index+1);

            // get allowed local IPs
            index = readUser.find(":");
            allLocIp = readUser;
            allLocIp.truncate(index);

            readUser.remove(0,index+1);

            // get denied local IPs
            index = readUser.find(":");
            denLocIp = readUser;
            denLocIp.truncate(index);

            readUser.remove(0,index+1);

            // get allowed client IPs
            index = readUser.find(":");
            allCliIp = readUser;
            allCliIp.truncate(index);

            readUser.remove(0,index+1);

            // get denied client IPs
            index = readUser.find(":");
            denCliIp = readUser;
            denCliIp.truncate(index);

            readUser.remove(0,index+1);


            //get time restrictions
            index = readUser.find(":");
            timeRest = readUser;
            readUser.truncate(index);

            if (timeRest.isEmpty())
            {
                timeRest = i18n("-");
            }



            //fill ListViewItem

            itemFirst = new KListViewItem(lstMainUser);
            itemFirst->setText(0,login);
            itemFirst->setText(1,fullName);
            itemFirst->setText(2,homeDir);
            itemFirst->setText(3,chroot);
            itemFirst->setText(4,userUid);
            itemFirst->setText(5,userGid);
            itemFirst->setText(6,upBand);
            itemFirst->setText(7,downBand);
            itemFirst->setText(8,maxFiles);
            itemFirst->setText(9,maxSize);
            itemFirst->setText(10,ratOut);
            itemFirst->setText(11,timeRest);
            itemFirst->setText(12,maxConn);
            itemFirst->setText(13,allLocIp);
            itemFirst->setText(14,denLocIp);
            itemFirst->setText(15,allCliIp);
            itemFirst->setText(16,denCliIp);

        }

        //close user file
        flGetUsers.close();
        lstMainUser->setSelected(lstMainUser->firstChild(),true);
        pCurrent = lstMainUser->selectedItem();

    }
    else
    {
        /*
           	if (KMessageBox::questionYesNo(this,i18n("It seems that you are not root, or you have to set the correct paths in the preferences dialog!\n Open preferences dialog?")) == 3)
        {
        startPref =  new UserAdminPref();
        startPref->show();

        }
        */
        /*itemErr = new KListViewItem(lstMainUser);
        itemErr->setText(0,i18n("It seems"));
        itemErr->setText(1,i18n("that you are"));
        itemErr->setText(2,i18n("not root,or you"));
        itemErr->setText(3,i18n("have to"));
        itemErr->setText(4,i18n("set the"));
        itemErr->setText(5,i18n("correct paths"));
        itemErr->setText(6,i18n("in the"));
        itemErr->setText(7,i18n("preferences"));
        itemErr->setText(8,i18n("dialog!!!"));*/

	btnDelUser->setEnabled(false);
        btnEditUser->setEnabled(false);
	btnAddUser->setEnabled(false);
    }

}

void UserAdmin::onListViewClicked(QListViewItem *lvi)
{
    btnAddUser->setEnabled(true);
    btnDelUser->setEnabled(true);
    btnEditUser->setEnabled(true);
    pCurrent = lvi;
}

void UserAdmin::slotShowPref()
{
    //the pref dialog
    PrefDialog = new UserAdminPref();

    PrefDialog->show();

}
void UserAdmin::slotRefresh()
{
    lstMainUser->clear();
    initUserList();

    CurrentUserInfo userInfo;

    if (lstMainUser->childCount() == 0)
    {
    	if (userInfo.getCurrentUser() != "root")
	{
        	btnAddUser->setEnabled(false);
	}
	else
	{
		btnAddUser->setEnabled(true);
	}
        btnDelUser->setEnabled(false);
        btnEditUser->setEnabled(false);
    }
    else
    {
        btnAddUser->setEnabled(true);
        btnDelUser->setEnabled(true);
        btnEditUser->setEnabled(true);
    }
}

void UserAdmin::slotAddUser()
{
    //the user add dialog

    AddDialog = new UserAdminAdd(urlSystemPasswdFile, urlSystemGroupFile);

    connect (AddDialog, SIGNAL (addDialogClosed()), this, SLOT (slotRefresh()));

    AddDialog->show();

}

void UserAdmin::slotEditUser()
{
    //the user edit dialog

    if (pCurrent)
    {
        EditDialog = new UserAdminEdit(urlSystemPasswdFile, urlSystemGroupFile, pCurrent);

        connect (EditDialog, SIGNAL (editDialogClosed()), this, SLOT (slotRefresh()));

        EditDialog->setCaption(i18n("Edit user %1 (%2)").arg(pCurrent->text(0)).arg(pCurrent->text(1)));
        EditDialog->show();

    }
    else
    {
        KMessageBox::sorry(this, i18n("Please select a user"));
    }
}

void UserAdmin::slotDelUser()
{
    delUser = new QProcess(this);
    QString del;


    if (!pCurrent)
    {
        KMessageBox::sorry(this, i18n("Please select a user"));
    }




    connect(delUser, SIGNAL(processExited()), this, SLOT(slotRefresh()));



    //if (!del.isEmpty());
    if(pCurrent != 0)
    {
        del = pCurrent->text(0);

        if (KMessageBox::questionYesNo(this,i18n("Do you want delete %1?").arg(del),i18n("Confim")) == 3)
        {


            delUser->addArgument("pure-pw");
            delUser->addArgument("userdel");

            delUser->addArgument(del);
            delUser->addArgument("-m");
            if (!delUser->start())
            {
                KMessageBox::sorry(this,i18n("Unable to delete user!"));
            }
        }

    }
}

void UserAdmin::configChanged()
{
}


void UserAdmin::showContextMenu(KListView *listview, QListViewItem *item, const QPoint &p){
  QListViewItem *tmp = item;
  tmp =0;

  if (lstMainUser->childCount() != 0)
  {
   KPopupMenu *contextMenu = new KPopupMenu (listview,i18n("select action"));
   contextMenu->insertItem(i18n("edit user"),this,SLOT(slotEditUser()));
   contextMenu->insertItem(i18n("change password"),this,SLOT(slotChPass()));
   contextMenu->insertSeparator();
   contextMenu->insertItem(i18n("add new user"),this,SLOT(slotAddUser()));
   contextMenu->insertSeparator();
   contextMenu->insertItem(i18n("delete user"),this,SLOT(slotDelUser()));
   contextMenu->setCheckable(true);
   contextMenu->popup(p);
   contextMenu->show();
	}
 }

 void UserAdmin::slotChPass() {

QString newPassword;
ChPassDialog *d = new ChPassDialog (pCurrent->text(0)) ;
d->show();

}

void UserAdmin::mouseDoubleClickEvent(QMouseEvent *e) {
    if(e->button() == LeftButton && pCurrent != 0)
        slotEditUser();
}
