/***************************************************************************
                          importdialogaladin.cpp  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.4 $
    date                 : $Date: 2002/04/13 18:26:56 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <iomanip.h>

#include <qprogressbar.h>
#include <qptrlist.h>

#include <klistview.h>
#include <kmessagebox.h>

#include "dive.h"
#include "interfacealadin.h"
#include "importdialogaladin.h"



ImportDialogAladin::DiveListViewItem::DiveListViewItem( const Dive &dive, KListView *parent )
    : KListViewItem( parent )
{
    QString txt;

    _number = dive.number();

    txt.sprintf( "%d", dive.number() );
    setText( 0, txt );
    
    txt.sprintf( "%s", dive.dateTime().date().toString( "dd.MM.yyyy" ).latin1() );
    setText( 1, txt );
    
    txt.sprintf( "%s", dive.dateTime().time().toString( "hh:mm" ).latin1() );
    setText( 2, txt );
    
    txt.sprintf( "%d min", dive.duration() );
    setText( 3, txt );
    
    txt.sprintf( "%d m", dive.depth() );
    setText( 4, txt );
    
    setText( 5, (dive.hasProfile() ? "yes" : "no") );
}


QString ImportDialogAladin::DiveListViewItem::key( int column, bool ascending ) const
{
    QString retVal;

    if( column == 0 )
    {
	retVal.sprintf( "%03d", _number );
	return retVal;
    }
    else
    {
	return KListViewItem::key( column, ascending );
    }
}


/**********************************************
 **********************************************/




ImportDialogAladin::ImportDialogAladin( QWidget *parent, const char *name,
					bool modal ) 
    : ImportDialogAladinGUI( parent, name, modal ) 
{
    _aladin = new InterfaceAladin();
    connect( _butCancel, SIGNAL(clicked()),
	     _aladin, SLOT(slotStopReading()) );
    connect( _aladin, SIGNAL(signalProgress(int)),
	     _progressBar, SLOT(setProgress(int)) );

    _progressBar->setTotalSteps( _aladin->getProgressSteps() );

    _listView->setAllColumnsShowFocus( true );
    _listView->setMultiSelection( true );
}


ImportDialogAladin::~ImportDialogAladin()
{
    delete _aladin;
}


void ImportDialogAladin::getSelectedDives( QPtrList< Dive > &diveList )
{
    Dive *dive;

    diveList.clear();

    for( DiveListViewItem *item = (DiveListViewItem *) _listView->firstChild();
	 item;
	 item = (DiveListViewItem *) item->nextSibling() )
    {
	if( item->isSelected() )
	{
	    dive = new Dive;
	    _aladin->getDive( item->diveNumber() - 1, *dive );
	    diveList.append( dive );
	}
    }
    
}


/**********************************************
 **********************************************/


void ImportDialogAladin::slotCancel( void )
{
    
    reject();
}

    
void ImportDialogAladin::slotImport( void )
{
    accept();
}


int ImportDialogAladin::exec( void )
{
    QString msg;
    InterfaceBase::retVal value;

    _butImport->setEnabled( false );

    show();


    do {

	value = _aladin->readData( "/dev/ttyS0" );
	
	if( value == InterfaceBase::ErrorOpen )
	{
	    msg.sprintf( "Could not open device!\nAborting." );
	    KMessageBox::error( this, msg, "Aladin Import" );
	    break;
	}
	else if( value == InterfaceBase::ErrorIoctl )
	{
	    msg.sprintf( "Ioctl-Error on device!\nAborting." );
	    KMessageBox::error( this, msg, "Aladin Import" );
	    break;
	}
	else if( value == InterfaceBase::ErrorRead )
	{
	    msg.sprintf( "Error while reading data!\nAborting." );
	    KMessageBox::error( this, msg, "Aladin Import" );
	    break;
	}
	else if( value == InterfaceBase::ErrorAgain )
	{
	    msg.sprintf( "Error while reading data.\nPlease repeat procedure !" );
	    if( KMessageBox::warningContinueCancel( this, msg, "Aladin Import" )
		== KMessageBox::Cancel )
		break;
	    else
		_progressBar->setProgress( 0 );
	}
	
    } while( value == InterfaceBase::ErrorAgain );



    if( value == InterfaceBase::Ok )
    {
	_butImport->setEnabled( true );

	// how many dives are saved in the aladin computer ?
	int number = _aladin->getNumberOfDives();

	Dive dive;
	DiveListViewItem *item;

	// get each available dive and insert it into the ListView
	for( int i = 0; i < number; i++ )
	{
	    _aladin->getDive( i, dive );

	    item = new DiveListViewItem( dive, _listView );
   	}

	return QDialog::exec();
    }
    

    return QDialog::Rejected;
}
