// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          interfacebase.h  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.3 $
    date                 : $Date: 2002/04/12 17:07:47 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef INTERFACEBASE_H
#define INTERFACEBASE_H


#include <qobject.h>

#include "dive.h"


// forward declarations
class QString;


//! Base Class for Dive-Computer interfaces
/*! Base Class for Dive-Computer interfaces

  \author Martin Habbecke
*/
class InterfaceBase : public QObject {

    Q_OBJECT

public: 
    //! Default Constructor
    InterfaceBase();

    //! Default Destructor
    virtual ~InterfaceBase();

    //! Possible return values of readData()
    enum retVal { Ok,            //!< All data has been read succesfully
		  Aborted,       //!< The user aborted readout
		  ErrorAgain,    //!< A bad checksum has been calculated, so ask user to try again
		  ErrorOpen,     //!< Could not open device
		  ErrorIoctl,    //!< Error while perfoming an ioctl on the device
		  ErrorRead      //!< Error while reading data
    };

    //! Function to read datablock from Aladin Computer
    virtual retVal readData( const QString &device ) = 0;


    //! Function to get the number of available dives
    virtual int getNumberOfDives( void ) = 0;

    //! Function to get the i-th dive
    virtual bool getDive( int index, Dive &dive ) = 0;



    //! Function to get the total number of progress-steps
    virtual int getProgressSteps( void ) = 0;


signals:
    //! Signal that tells the progress of the readout
    void signalProgress( int progress );


};


#endif
